<?php
require 'vendor/autoload.php';

// Database configuration
$dbConfig = [
    'host' => 'localhost',
    'dbname' => 'b2b_travel',
    'user' => 'root',
    'pass' => ''
];

try {
    $pdo = new PDO(
        "mysql:host={$dbConfig['host']};dbname={$dbConfig['dbname']};charset=utf8mb4",
        $dbConfig['user'],
        $dbConfig['pass'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );

    // Check if wallet_transactions table exists
    $tables = $pdo->query("SHOW TABLES LIKE 'wallet_%'")->fetchAll(PDO::FETCH_COLUMN);
    
    if (empty($tables)) {
        echo "No wallet-related tables found.\n";
    } else {
        echo "Found wallet tables: " . implode(', ', $tables) . "\n\n";
        
        // Show structure of each wallet table
        foreach ($tables as $table) {
            echo "=== $table table structure ===\n";
            $stmt = $pdo->query("SHOW CREATE TABLE `$table`");
            $result = $stmt->fetch();
            echo $result["Create Table"] . "\n\n";
        }
    }

} catch (PDOException $e) {
    die("Error: " . $e->getMessage() . "\n");
}
