<?php
require 'vendor/autoload.php';

// Database configuration - adjust these as needed
$dbConfig = [
    'host' => 'localhost',
    'user' => 'root',
    'pass' => ''
];

try {
    // First, connect without database to list all databases
    $pdo = new PDO(
        "mysql:host={$dbConfig['host']};charset=utf8mb4",
        $dbConfig['user'],
        $dbConfig['pass'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );

    // List all databases
    $stmt = $pdo->query("SHOW DATABASES");
    $databases = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    echo "Available databases:\n";
    foreach ($databases as $db) {
        echo "- $db\n";
    }

} catch (PDOException $e) {
    die("Error: " . $e->getMessage() . "\n");
}
