/** Tailwind config for Agent Portal (isolated) */
module.exports = {
  content: [
    './app/Views/agent/**/*.php',
  ],
  theme: {
    extend: {
      colors: {
        primary: {
          50: '#eef5ff',
          100: '#d9e9ff',
          200: '#b3d2ff',
          300: '#85b6ff',
          400: '#5593ff',
          500: '#2f74ff',
          600: '#1e5ae6',
          700: '#1a49b3',
          800: '#193f8f',
          900: '#183571',
        },
      },
    },
  },
  plugins: [require('daisyui')],
  daisyui: {
    themes: [
      {
        agent: {
          primary: '#2f74ff',
          secondary: '#0ea5e9',
          accent: '#22c55e',
          neutral: '#3d4451',
          'base-100': '#ffffff',
          info: '#3abff8',
          success: '#36d399',
          warning: '#fbbd23',
          error: '#f87272',
        },
      },
    ],
    base: true,
    styled: true,
    utils: true,
    logs: false,
    rtl: false,
    darkTheme: 'light',
  },
};
