<?php
// scripts/send_elastic_test.php
// Quick standalone Elastic Email cURL test sender.
// How to run (choose one):
// 1) Browser: http://localhost/b3bthaihub.com/scripts/send_elastic_test.php
// 2) CLI:     php scripts/send_elastic_test.php

error_reporting(E_ALL);
ini_set('display_errors', '1');

$url = 'https://api.elasticemail.com/v2/email/send';

// Try to read from environment first (preferred)
$apiKey = getenv('ELASTICEMAIL_API_KEY') ?: '';
$from   = getenv('MAIL_FROM_ADDRESS') ?: '';
$fromName = getenv('MAIL_FROM_NAME') ?: 'B2B Thai Hub';

// If env is empty, you can hardcode for a one-off test (NOT recommended to commit)
if ($apiKey === '') {
    // TODO: replace with your key for a local test, or ensure .env is loaded by your runtime
    $apiKey = 'REPLACE_WITH_YOUR_ELASTICEMAIL_API_KEY';
}
if ($from === '') {
    // Use a verified sender/domain in Elastic Email
    $from = 'admin@bookmythai.com';
}

// Set recipients: semicolon separated for multiple
$to = 'you@example.com'; // e.g. 'user1@gmail.com;user2@gmail.com'

$subject = 'Elastic Email Direct API Test';
$bodyHtml = '<h2>Elastic Email Test</h2><p>If you see this, the API call worked.</p>';
$bodyText = 'Elastic Email Test - If you see this, the API call worked.';

$post = [
    'from' => $from,
    'fromName' => $fromName,
    'apikey' => $apiKey,
    'subject' => $subject,
    'to' => $to,
    'bodyHtml' => $bodyHtml,
    'bodyText' => $bodyText,
    'isTransactional' => 'true',
];

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $url,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => http_build_query($post),
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HEADER => false,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_TIMEOUT => 20,
]);

$response = curl_exec($ch);
$error    = curl_error($ch);
$httpCode = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

header('Content-Type: text/plain; charset=utf-8');
if ($error) {
    echo "cURL error: {$error}\n";
}

echo "HTTP {$httpCode}\n";
echo "Response:\n{$response}\n";

// Parse and display some helpful info
$parsed = json_decode((string)$response, true);
if (is_array($parsed)) {
    $success = $parsed['success'] ?? null;
    $messageId = $parsed['data']['messageid'] ?? null;
    $errorMsg = $parsed['error'] ?? null;
    echo "\nParsed: success=" . var_export($success, true) . ", messageId=" . var_export($messageId, true) . ", error=" . var_export($errorMsg, true) . "\n";
}
