@echo off
setlocal
set "URL=http://localhost"

REM Open ONLY in Chromium. Never fallback to Edge/Chrome.
REM Optionally set CHROMIUM_PATH to override detection.

if defined CHROMIUM_PATH (
  if exist "%CHROMIUM_PATH%" goto launch_custom
  echo CHROMIUM_PATH is set but not found: "%CHROMIUM_PATH%"
)

set "EXE="
if exist "%LOCALAPPDATA%\Chromium\Application\chrome.exe" set "EXE=%LOCALAPPDATA%\Chromium\Application\chrome.exe"
if not defined EXE if exist "C:\Program Files\Chromium\Application\chrome.exe" set "EXE=C:\Program Files\Chromium\Application\chrome.exe"
if not defined EXE if exist "C:\Program Files (x86)\Chromium\Application\chrome.exe" set "EXE=C:\Program Files (x86)\Chromium\Application\chrome.exe"

if defined EXE goto launch

echo.
echo [Error] Chromium not found in common paths.
echo Try one of the following:
echo   1) Install Chromium (https://chromium.woolyss.com/), then re-run this script
echo   2) Set CHROMIUM_PATH to your chromium.exe path, e.g.
echo      set CHROMIUM_PATH=C:\Path\To\Chromium\chrome.exe
echo      and run this script again.
echo.
exit /b 1

:launch_custom
echo Launching (CHROMIUM_PATH): "%CHROMIUM_PATH%" --new-window --auto-open-devtools-for-tabs %URL%
start "" "%CHROMIUM_PATH%" --new-window --auto-open-devtools-for-tabs %URL%
exit /b 0

:launch
echo Launching: "%EXE%" --new-window --auto-open-devtools-for-tabs %URL%
start "" "%EXE%" --new-window --auto-open-devtools-for-tabs %URL%
exit /b 0
