<?php
// public/index.php - Front Controller
 $cfg = require dirname(__DIR__) . '/config/config.php';
 // Ensure config returned expected structure and PDO instance
 if (!is_array($cfg)) {
     http_response_code(500);
     die('Invalid config: config/config.php must return an array.');
 }
 if (!isset($cfg['pdo']) || !($cfg['pdo'] instanceof PDO)) {
     http_response_code(500);
     die('Invalid config: missing valid PDO instance in $cfg["pdo"].');
 }

// Composer autoloader (for Stripe SDK, etc.)
$composerAutoload = dirname(__DIR__) . '/vendor/autoload.php';
if (file_exists($composerAutoload)) {
    require_once $composerAutoload;
}

require_once dirname(__DIR__) . '/app/Core/Router.php';
require_once dirname(__DIR__) . '/app/Core/Controller.php';
require_once dirname(__DIR__) . '/app/Core/Model.php';
require_once dirname(__DIR__) . '/app/Core/View.php';
require_once dirname(__DIR__) . '/app/Core/Security.php';
require_once dirname(__DIR__) . '/app/Core/Auth.php';
require_once dirname(__DIR__) . '/app/Core/Audit.php';
require_once dirname(__DIR__) . '/app/Core/Env.php';
require_once dirname(__DIR__) . '/app/Core/Upload.php';
// Middleware (manual include; no app namespace autoloader)
require_once dirname(__DIR__) . '/app/Middleware/AuthGuard.php';
require_once dirname(__DIR__) . '/app/Middleware/RoleGuard.php';
require_once dirname(__DIR__) . '/app/Middleware/AgentGuard.php';
// Mail template renderer (manual include; no Composer autoload)
require_once dirname(__DIR__) . '/app/Core/Mail/Template.php';
// Mailer wrapper
require_once dirname(__DIR__) . '/app/Core/Mail/Mailer.php';
// Mail service + interfaces/providers (manual include to ensure availability without composer dump)
require_once dirname(__DIR__) . '/app/Core/Mail/ProviderInterface.php';
require_once dirname(__DIR__) . '/app/Core/Mail/MailService.php';
require_once dirname(__DIR__) . '/app/Core/Mail/Providers/SesProvider.php';
// Menu system (no composer autoload, so require manually)
require_once dirname(__DIR__) . '/app/Core/Menu/MenuItem.php';
require_once dirname(__DIR__) . '/app/Core/Menu/AdminMenu.php';
require_once dirname(__DIR__) . '/app/Controllers/HomeController.php';
require_once dirname(__DIR__) . '/app/Controllers/AuthController.php';
// Role dashboards used by routes (/customer, /employee, /partner)
require_once dirname(__DIR__) . '/app/Controllers/CustomerController.php';
require_once dirname(__DIR__) . '/app/Controllers/EmployeeController.php';
require_once dirname(__DIR__) . '/app/Controllers/PartnerController.php';
require_once dirname(__DIR__) . '/app/Controllers/UsersController.php';
require_once dirname(__DIR__) . '/app/Controllers/HotelsController.php';
require_once dirname(__DIR__) . '/app/Controllers/ApiController.php';
require_once dirname(__DIR__) . '/app/Controllers/AdminController.php';
require_once dirname(__DIR__) . '/app/Controllers/SupportController.php';
require_once dirname(__DIR__) . '/app/Controllers/PromoController.php';
require_once dirname(__DIR__) . '/app/Controllers/CorporateController.php';
require_once dirname(__DIR__) . '/app/Services/WalletService.php';
require_once dirname(__DIR__) . '/app/Services/ChannelPartnerWalletService.php';
// New admin area controllers
require_once dirname(__DIR__) . '/app/Controllers/BookingController.php';
require_once dirname(__DIR__) . '/app/Controllers/VendorsController.php';
require_once dirname(__DIR__) . '/app/Controllers/ActivitiesController.php';
require_once dirname(__DIR__) . '/app/Controllers/TaxisController.php';
// Admin Taxi management controller (needed for /admin/taxis)
require_once dirname(__DIR__) . '/app/Controllers/TaxiAdminController.php';
// Admin Airports and Taxi Itineraries (manual include required)
require_once dirname(__DIR__) . '/app/Controllers/AirportsAdminController.php';
require_once dirname(__DIR__) . '/app/Controllers/TaxiItinerariesAdminController.php';
// Admin Hotels management controller (needed for /admin/hotels)
require_once dirname(__DIR__) . '/app/Controllers/HotelsAdminController.php';
// Admin Yachts management controller (needed for /admin/yachts)
require_once dirname(__DIR__) . '/app/Controllers/YachtsAdminController.php';
require_once dirname(__DIR__) . '/app/Controllers/EvisasController.php';
require_once dirname(__DIR__) . '/app/Controllers/ToolsController.php';
require_once dirname(__DIR__) . '/app/Controllers/ManagementController.php';
require_once dirname(__DIR__) . '/app/Controllers/CategoriesController.php';
require_once dirname(__DIR__) . '/app/Controllers/SettingsController.php';
require_once dirname(__DIR__) . '/app/Controllers/MediaController.php';
// Agent portal (Tailwind + DaisyUI)
require_once dirname(__DIR__) . '/app/Controllers/AgentPortalController.php';
require_once dirname(__DIR__) . '/app/Controllers/AgentKycController.php';
// Vendor Packages
require_once dirname(__DIR__) . '/app/Controllers/PackagesController.php';
// Holiday Packages module removed (controller not present)
// KYC Reviews
require_once dirname(__DIR__) . '/app/Controllers/KycController.php';
// B2B Agent JSON API
require_once dirname(__DIR__) . '/app/Controllers/B2BApiController.php';
// Standalone Checkout page
require_once dirname(__DIR__) . '/app/Controllers/CheckoutController.php';
// Payments & Gateways
require_once dirname(__DIR__) . '/app/Controllers/PaymentsController.php';
// Vendor Portal controllers (manual include)
require_once dirname(__DIR__) . '/app/Controllers/VendorAuthController.php';
require_once dirname(__DIR__) . '/app/Controllers/VendorPortalController.php';
require_once dirname(__DIR__) . '/app/Controllers/VendorDispatchController.php';
// Wallet Deposit workflow controllers
require_once dirname(__DIR__) . '/app/Controllers/AgentWalletDepositsController.php';
require_once dirname(__DIR__) . '/app/Controllers/AdminWalletDepositsController.php';
// Company Bank Accounts (Admin)
require_once dirname(__DIR__) . '/app/Controllers/CompanyBankAccountsAdminController.php';
// Secure file streaming
require_once dirname(__DIR__) . '/app/Controllers/FileController.php';

use App\Core\Router;

$router = new Router($cfg['pdo']);

// Load routes
require dirname(__DIR__) . '/app/Routes/web.php';
if (file_exists(dirname(__DIR__) . '/app/Routes/api.php')) {
    require dirname(__DIR__) . '/app/Routes/api.php';
}

// Dispatch with safety net to catch unexpected fatals on production
try {
    $router->dispatch();
} catch (Throwable $e) {
    // Minimal file logger with fallbacks: app log -> PHP error_log -> system temp
    $ref = function_exists('random_bytes') ? bin2hex(random_bytes(8)) : (string)mt_rand();
    if (!headers_sent()) { @header('X-Error-Ref: ' . $ref); }

    $logDir = dirname(__DIR__) . DIRECTORY_SEPARATOR . 'writable' . DIRECTORY_SEPARATOR . 'logs';
    if (!is_dir($logDir)) { @mkdir($logDir, 0755, true); }
    $logFile = $logDir . DIRECTORY_SEPARATOR . 'app-' . date('Y-m-d') . '.log';
    $msg = '[' . date('H:i:s') . "] [$ref] FATAL " . $e->getMessage() . " in " . $e->getFile() . ':' . $e->getLine() . "\n" . $e->getTraceAsString() . "\n";
    $wrote = @file_put_contents($logFile, $msg, FILE_APPEND);
    if ($wrote === false) {
        $errLogged = @error_log($msg);
        if ($errLogged === false) {
            // Final fallback: write to system temp directory
            $tmp = rtrim((string)@sys_get_temp_dir(), DIRECTORY_SEPARATOR);
            if ($tmp !== '') {
                @file_put_contents($tmp . DIRECTORY_SEPARATOR . 'agent_app.log', $msg, FILE_APPEND);
            }
        }
    }

    http_response_code(500);
    if (!empty($cfg['debug'])) {
        echo '<h3>Unhandled error</h3><pre>' . htmlspecialchars($e->getMessage()) . "\n\n" . htmlspecialchars($e->getFile() . ':' . $e->getLine()) . "\n\n" . htmlspecialchars($e->getTraceAsString()) . '</pre>';
    } else {
        echo 'Internal Server Error';
        echo '\n<!-- Error Ref: ' . htmlspecialchars($ref) . ' -->';
    }
}

