(function($){
  if (!$) { try { console.warn('app.js: jQuery not loaded; skipping initialization'); } catch(e){} return; }
  $(function(){
  // Global AJAX CSRF header
  $.ajaxSetup({
    headers: { 'X-CSRF-TOKEN': window.CSRF_TOKEN }
  });

  // KYC Settings: Per Business Type — Media overrides
  function bindMediaOverrideToggles() {
    $("input[id$='_OVERRIDE_MEDIA']").each(function(){
      const $override = $(this);
      const $pane = $override.closest('.tab-pane');
      if ($pane.length === 0) return;

      const $targets = $pane.find([
        "input[id$='_PROFILE_PHOTO_ENABLE']",
        "input[id$='_PROFILE_PHOTO_REQUIRE']",
        "input[id$='_BUSINESS_CARD_ENABLE']",
        "input[id$='_BUSINESS_CARD_REQUIRE']"
      ].join(','));

      const applyState = () => {
        const on = $override.is(':checked');
        $targets.prop('disabled', !on);
      };

      // Initial state and on change
      applyState();
      $override.on('change', applyState);
    });
  }

  // KYC Settings: Per Business Type — Government ID overrides
  function bindGovIdOverrideToggles() {
    $("input[id$='_OVERRIDE_GOVID']").each(function(){
      const $override = $(this);
      const $pane = $override.closest('.tab-pane');
      if ($pane.length === 0) return;

      const $targets = $pane.find([
        "input[id$='_REQUIRE_ID_TYPE']",
        "input[id$='_REQUIRE_ID_NUMBER']",
        "input[id$='_ENABLE_ID_FRONT']",
        "input[id$='_REQUIRE_ID_FRONT']",
        "input[id$='_ENABLE_ID_BACK']",
        "input[id$='_REQUIRE_ID_BACK']"
      ].join(','));

      const applyState = () => {
        const on = $override.is(':checked');
        $targets.prop('disabled', !on);
      };

      applyState();
      $override.on('change', applyState);
    });
  }

  // KYC Settings: Per Business Type — Registration overrides (IATA/GST)
  function bindRegOverrideToggles() {
    $("input[id$='_OVERRIDE_REG']").each(function(){
      const $override = $(this);
      const $pane = $override.closest('.tab-pane');
      if ($pane.length === 0) return;

      const $targets = $pane.find([
        // IATA
        "input[id$='_IATA_ENABLE']",
        "input[id$='_IATA_REQUIRE_CODE']",
        // GST
        "input[id$='_GST_NUMBER_ENABLE']",
        "input[id$='_GST_NUMBER_REQUIRE']",
        "input[id$='_GST_COMPANY_ENABLE']",
        "input[id$='_GST_COMPANY_REQUIRE']"
      ].join(','));

      const applyState = () => {
        const on = $override.is(':checked');
        $targets.prop('disabled', !on);
      };

      applyState();
      $override.on('change', applyState);
    });
  }

  // KYC Settings: Per Business Type — Business Documents overrides
  function bindDocsOverrideToggles() {
    $("input[id$='_OVERRIDE_DOCS']").each(function(){
      const $override = $(this);
      const $pane = $override.closest('.tab-pane');
      if ($pane.length === 0) return;

      const $targets = $pane.find([
        "input[id$='_SELFIE_ENABLE']",
        "input[id$='_SELFIE_REQUIRE']",
        "input[id$='_ADDRESS_PROOF_ENABLE']",
        "input[id$='_ADDRESS_PROOF_REQUIRE']"
      ].join(','));

      const applyState = () => {
        const on = $override.is(':checked');
        $targets.prop('disabled', !on);
      };

      // Initial state and on change
      applyState();
      $override.on('change', applyState);
    });
  }

  // Within a pane: 'Enable' controls 'Require' for each media item
  function bindEnableRequireDependencies() {
    $('.tab-pane').each(function(){
      const $pane = $(this);

      const pairs = [
        { enable: "input[id$='_PROFILE_PHOTO_ENABLE']", require: "input[id$='_PROFILE_PHOTO_REQUIRE']" },
        { enable: "input[id$='_BUSINESS_CARD_ENABLE']", require: "input[id$='_BUSINESS_CARD_REQUIRE']" },
        // Docs
        { enable: "input[id$='_SELFIE_ENABLE']", require: "input[id$='_SELFIE_REQUIRE']" },
        { enable: "input[id$='_ADDRESS_PROOF_ENABLE']", require: "input[id$='_ADDRESS_PROOF_REQUIRE']" },
        // Gov ID
        { enable: "input[id$='_ENABLE_ID_FRONT']", require: "input[id$='_REQUIRE_ID_FRONT']" },
        { enable: "input[id$='_ENABLE_ID_BACK']", require: "input[id$='_REQUIRE_ID_BACK']" },
        // Registration
        { enable: "input[id$='_IATA_ENABLE']", require: "input[id$='_IATA_REQUIRE_CODE']" },
        { enable: "input[id$='_GST_NUMBER_ENABLE']", require: "input[id$='_GST_NUMBER_REQUIRE']" },
        { enable: "input[id$='_GST_COMPANY_ENABLE']", require: "input[id$='_GST_COMPANY_REQUIRE']" }
      ];

      pairs.forEach(({enable, require}) => {
        const $en = $pane.find(enable);
        const $req = $pane.find(require);
        if ($en.length === 0 || $req.length === 0) return;

        const apply = () => {
          const enabled = $en.is(':checked');
          $req.prop('disabled', !enabled);
          if (!enabled) $req.prop('checked', false);
        };

        apply();
        $en.off('change._dep').on('change._dep', apply);
      });
    });
  }

  // Run on load; re-run when tabs are switched just in case content is lazy-rendered
  bindMediaOverrideToggles();
  bindDocsOverrideToggles();
  bindGovIdOverrideToggles();
  bindRegOverrideToggles();
  bindEnableRequireDependencies();
  
  // Per Business Type: Enable All / Disable All
  function bindPerTypeSelectAll() {
    // Enable All in a pane
    $(document).off('click.kyc', '.btn-kyc-enable-all').on('click.kyc', '.btn-kyc-enable-all', function(e){
      e.preventDefault();
      const $pane = $(this).closest('.tab-pane');
      if ($pane.length === 0) return;
      // Turn ON all overrides within pane so inner toggles are enabled
      $pane.find("input[id$='_OVERRIDE_GOVID'], input[id$='_OVERRIDE_REG'], input[id$='_OVERRIDE_DOCS'], input[id$='_OVERRIDE_MEDIA']").prop('checked', true).trigger('change');
      // Check all checkboxes in this pane
      $pane.find('input[type=checkbox]').prop('checked', true).prop('disabled', false);
    });
    // Disable All in a pane
    $(document).off('click.kyc', '.btn-kyc-disable-all').on('click.kyc', '.btn-kyc-disable-all', function(e){
      e.preventDefault();
      const $pane = $(this).closest('.tab-pane');
      if ($pane.length === 0) return;
      // Uncheck all checkboxes
      $pane.find('input[type=checkbox]').prop('checked', false);
      // Turn OFF overrides last so inner toggles become disabled
      $pane.find("input[id$='_OVERRIDE_GOVID'], input[id$='_OVERRIDE_REG'], input[id$='_OVERRIDE_DOCS'], input[id$='_OVERRIDE_MEDIA']").prop('checked', false).trigger('change');
    });
  }
  bindPerTypeSelectAll();
  $(document).on('shown.bs.tab', 'button[data-bs-toggle="tab"]', bindPerTypeSelectAll);
  $(document).on('shown.bs.tab', 'button[data-bs-toggle="tab"]', bindMediaOverrideToggles);
  $(document).on('shown.bs.tab', 'button[data-bs-toggle="tab"]', bindDocsOverrideToggles);
  $(document).on('shown.bs.tab', 'button[data-bs-toggle="tab"]', bindGovIdOverrideToggles);
  $(document).on('shown.bs.tab', 'button[data-bs-toggle="tab"]', bindRegOverrideToggles);
  $(document).on('shown.bs.tab', 'button[data-bs-toggle="tab"]', bindEnableRequireDependencies);

  // Channel Partner create form: clamp percent fields to [0, 30]
  function clampPercentInputs() {
    const sel = "input[name='default_margin_percent'], input[name='fallback_share_percent']";
    $(document).off('input.cp clamp.cp change.cp blur.cp', sel)
      .on('input.cp clamp.cp change.cp blur.cp', sel, function(){
        const min = 0, max = 30;
        let v = $(this).val();
        if (v === '' || v === null) return; // allow empty while typing
        let n = parseFloat(v);
        if (isNaN(n)) { $(this).val(''); return; }
        if (n < min) n = min;
        if (n > max) n = max;
        // Keep at most 2 decimals
        $(this).val(n.toFixed(2).replace(/\.00$/, '.00'));
      });
  }
  clampPercentInputs();
  });
})(window.jQuery);
