# Inter font (self-hosted)

This project uses the Inter font locally for offline reliability and consistent rendering.

## Expected files (drop-in)
Place the following files in this folder so they match the `@font-face` URLs referenced by `static-prototype/styles.css`:

- inter-latin-400-normal.woff2
- inter-latin-600-normal.woff2
- inter-latin-700-normal.woff2

If you want additional weights, add them here and update `styles.css` accordingly.

## Where to get the files
- Official repo (preferred): https://github.com/rsms/inter/releases
- Google Fonts (download family as ZIP): https://fonts.google.com/specimen/Inter

Choose the static WOFF2 builds (not variable) and rename them to the exact names above if needed.

## License
The Inter font is licensed under the SIL Open Font License (OFL). See `OFL.txt` in this folder.

## Notes
- The `@font-face` rules are already defined in `static-prototype/styles.css` and point to `assets/fonts/inter/*.woff2` relative to that CSS file.
- No changes are required after placing the files. Just refresh the browser and check DevTools > Network to confirm the `.woff2` files load (status 200).
- Avoid mixing Google Fonts link tags with these local files to prevent double-loading.
