// Page transition loading overlay controller
document.addEventListener('DOMContentLoaded', function() {
  const links = document.querySelectorAll('a:not([target="_blank"]):not([href^="#"]):not([href^="javascript:"]):not([download])');
  const loadingOverlay = document.getElementById('pageLoading');

  function showLoading() {
    if (loadingOverlay) {
      loadingOverlay.style.opacity = '1';
      loadingOverlay.style.pointerEvents = 'auto';
    }
  }
  function hideLoading() {
    if (loadingOverlay) {
      loadingOverlay.style.opacity = '0';
      loadingOverlay.style.pointerEvents = 'none';
    }
  }

  // Ensure hidden on initial DOM ready (especially when coming from bfcache)
  hideLoading();

  // Show overlay on normal link navigation, but do NOT force redirect
  links.forEach(link => {
    if (link.href === window.location.href) return; // same page
    link.addEventListener('click', function() {
      showLoading();
      // Allow browser to navigate naturally; no manual window.location assignment
    });
  });

  // Show on unload (navigating away)
  window.addEventListener('beforeunload', showLoading);

  // Hide on load (normal navigation)
  window.addEventListener('load', hideLoading);

  // Hide on pageshow (handles back/forward cache where 'load' may not fire)
  window.addEventListener('pageshow', function(ev) {
    // Always hide when the page becomes visible again (including bfcache)
    hideLoading();
  });

  // Hide on popstate (history back/forward in SPAs or some browsers)
  window.addEventListener('popstate', hideLoading);

  // Hide when tab becomes visible (safety net)
  document.addEventListener('visibilitychange', function() {
    if (document.visibilityState === 'visible') hideLoading();
  });
});
