<?php
// fix_vendor_id.php
require __DIR__ . '/config/config.php';

$email = 'ancientjbrx@gmail.com';

try {
    // Get the user
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ? AND role = 'Vendor'");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user) {
        die("Vendor user not found: $email");
    }
    
    // Get vendor by email
    $stmt = $pdo->prepare("SELECT * FROM vendors WHERE contact_email = ?");
    $stmt->execute([$email]);
    $vendor = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$vendor) {
        die("Vendor record not found for email: $email");
    }
    
    // Update user's vendor_id
    $update = $pdo->prepare("UPDATE users SET vendor_id = ? WHERE id = ?");
    $update->execute([$vendor['id'], $user['id']]);
    
    echo "✅ Updated user {$user['id']} with vendor_id: {$vendor['id']} ({$vendor['name']})\n";
    
} catch (PDOException $e) {
    die("Error: " . $e->getMessage());
}
