<?php
require_once __DIR__ . '/config/config.php';

header('Content-Type: text/plain');

try {
    $db = $pdo;
    $dbName = $db->query('SELECT DATABASE()')->fetchColumn();
    echo "DB: " . $dbName . "\n";

    $tables = $db->query("SHOW TABLES LIKE 'support_%'")->fetchAll(PDO::FETCH_COLUMN);
    echo "Tables: " . json_encode($tables) . "\n\n";

    $cnt = $db->query('SELECT COUNT(*) FROM support_tickets')->fetchColumn();
    echo "support_tickets count: $cnt\n";

    $sample = $db->query('SELECT id, user_id, subject, status, created_at, updated_at FROM support_tickets ORDER BY id DESC LIMIT 5')->fetchAll(PDO::FETCH_ASSOC);
    echo "\nLatest tickets:\n";
    foreach ($sample as $row) {
        echo json_encode($row, JSON_UNESCAPED_SLASHES) . "\n";
    }

    $rcnt = $db->query('SELECT COUNT(*) FROM support_replies')->fetchColumn();
    echo "\nsupport_replies count: $rcnt\n";

    $rsample = $db->query('SELECT id, ticket_id, role, created_at FROM support_replies ORDER BY id DESC LIMIT 5')->fetchAll(PDO::FETCH_ASSOC);
    echo "\nLatest replies:\n";
    foreach ($rsample as $row) {
        echo json_encode($row, JSON_UNESCAPED_SLASHES) . "\n";
    }

    // Check if users table has entries for these user_id values
    $uids = $db->query('SELECT DISTINCT user_id FROM support_tickets ORDER BY user_id DESC LIMIT 10')->fetchAll(PDO::FETCH_COLUMN);
    echo "\nDistinct user_ids in tickets: " . json_encode($uids) . "\n";
    if ($uids) {
        $in = implode(',', array_map('intval', $uids));
        $umap = $db->query("SELECT id, email FROM users WHERE id IN ($in) ORDER BY id DESC")->fetchAll(PDO::FETCH_KEY_PAIR);
        echo "Users found for those IDs: " . json_encode($umap) . "\n";
        // Also check agents table, in case user_id actually points there
        $amap = $db->query("SELECT id, email FROM agents WHERE id IN ($in) ORDER BY id DESC")->fetchAll(PDO::FETCH_KEY_PAIR);
        echo "Agents found for those IDs: " . json_encode($amap) . "\n";
    }

} catch (Throwable $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
