<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Start the session
session_start();

// Log the current session data
error_log('Session ID: ' . session_id());
error_log('Session data: ' . print_r($_SESSION, true));

// Output session info for debugging
echo '<h1>Session Debug Information</h1>';
echo '<h2>Session ID:</h2>';
echo '<pre>' . session_id() . '</pre>';

echo '<h2>Session Data:</h2>';
echo '<pre>' . print_r($_SESSION, true) . '</pre>';

// Check if session is writable
$testKey = 'test_' . time();
$_SESSION[$testKey] = 'test_value';
$isWritable = ($_SESSION[$testKey] === 'test_value');

echo '<h2>Session Write Test:</h2>';
echo $isWritable ? '✅ Session is writable' : '❌ Session is not writable';

// Check session save path
$savePath = session_save_path();
$isWritablePath = is_writable($savePath);

echo '<h2>Session Save Path:</h2>';
echo '<p>' . htmlspecialchars($savePath) . ' - ';
echo $isWritablePath ? '✅ Writable' : '❌ Not Writable';
echo '</p>';

// Check for session configuration issues
if (ini_get('session.use_cookies') == '0') {
    echo '<div style="color: red;">Warning: session.use_cookies is disabled. Sessions may not work properly.</div>';
}

if (ini_get('session.use_only_cookies') == '0') {
    echo '<div style="color: orange;">Note: session.use_only_cookies is disabled. This might be a security risk.</div>';
}

// Check if headers have been sent
if (headers_sent($filename, $linenum)) {
    echo "<div style='color: red;'>Headers already sent in $filename on line $linenum</div>";
}
?>
