-- Check and add vendor process tracking fields to activity_bookings table

-- 1. First, check and add columns if they don't exist
SET @dbname = DATABASE();
SET @tablename = 'activity_bookings';
SET @preparedStatement = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = @dbname 
     AND TABLE_NAME = @tablename 
     AND COLUMN_NAME = 'vendor_cost'
    ) > 0,
    'SELECT 1',
    'ALTER TABLE `activity_bookings` ADD COLUMN `vendor_cost` DECIMAL(10,2) DEFAULT NULL AFTER `amount_total`;'
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Repeat for other columns
SET @preparedStatement = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = @dbname 
     AND TABLE_NAME = @tablename 
     AND COLUMN_NAME = 'vendor_currency'
    ) > 0,
    'SELECT 1',
    'ALTER TABLE `activity_bookings` ADD COLUMN `vendor_currency` VARCHAR(3) COLLATE utf8mb4_general_ci DEFAULT "THB" AFTER `vendor_cost`;'
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Add vendor_pay_status
SET @preparedStatement = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = @dbname 
     AND TABLE_NAME = @tablename 
     AND COLUMN_NAME = 'vendor_pay_status'
    ) > 0,
    'SELECT 1',
    'ALTER TABLE `activity_bookings` ADD COLUMN `vendor_pay_status` ENUM("pending", "cleared") COLLATE utf8mb4_general_ci NOT NULL DEFAULT "pending" AFTER `vendor_currency`;'
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Add vendor_paid_at
SET @preparedStatement = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = @dbname 
     AND TABLE_NAME = @tablename 
     AND COLUMN_NAME = 'vendor_paid_at'
    ) > 0,
    'SELECT 1',
    'ALTER TABLE `activity_bookings` ADD COLUMN `vendor_paid_at` DATETIME DEFAULT NULL AFTER `vendor_pay_status`;'
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Add vendor_invoice_no
SET @preparedStatement = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = @dbname 
     AND TABLE_NAME = @tablename 
     AND COLUMN_NAME = 'vendor_invoice_no'
    ) > 0,
    'SELECT 1',
    'ALTER TABLE `activity_bookings` ADD COLUMN `vendor_invoice_no` VARCHAR(50) COLLATE utf8mb4_general_ci DEFAULT NULL AFTER `vendor_paid_at`;'
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Add vendor_pay_note
SET @preparedStatement = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = @dbname 
     AND TABLE_NAME = @tablename 
     AND COLUMN_NAME = 'vendor_pay_note'
    ) > 0,
    'SELECT 1',
    'ALTER TABLE `activity_bookings` ADD COLUMN `vendor_pay_note` VARCHAR(255) COLLATE utf8mb4_general_ci DEFAULT NULL AFTER `vendor_invoice_no`;'
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Add vendor_pay_method
SET @preparedStatement = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = @dbname 
     AND TABLE_NAME = @tablename 
     AND COLUMN_NAME = 'vendor_pay_method'
    ) > 0,
    'SELECT 1',
    'ALTER TABLE `activity_bookings` ADD COLUMN `vendor_pay_method` ENUM("bank_transfer", "cash", "other") COLLATE utf8mb4_general_ci DEFAULT NULL AFTER `vendor_pay_note`;'
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Add vendor_pay_txn_id
SET @preparedStatement = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = @dbname 
     AND TABLE_NAME = @tablename 
     AND COLUMN_NAME = 'vendor_pay_txn_id'
    ) > 0,
    'SELECT 1',
    'ALTER TABLE `activity_bookings` ADD COLUMN `vendor_pay_txn_id` VARCHAR(100) COLLATE utf8mb4_general_ci DEFAULT NULL AFTER `vendor_pay_method`;'
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Add vendor_assigned_at
SET @preparedStatement = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = @dbname 
     AND TABLE_NAME = @tablename 
     AND COLUMN_NAME = 'vendor_assigned_at'
    ) > 0,
    'SELECT 1',
    'ALTER TABLE `activity_bookings` ADD COLUMN `vendor_assigned_at` DATETIME DEFAULT NULL AFTER `paid_at`;'
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Add vendor_accepted_at
SET @preparedStatement = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = @dbname 
     AND TABLE_NAME = @tablename 
     AND COLUMN_NAME = 'vendor_accepted_at'
    ) > 0,
    'SELECT 1',
    'ALTER TABLE `activity_bookings` ADD COLUMN `vendor_accepted_at` DATETIME DEFAULT NULL AFTER `vendor_assigned_at`;'
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Add vendor_processed_by with matching data type to users.id
SET @preparedStatement = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = @dbname 
     AND TABLE_NAME = @tablename 
     AND COLUMN_NAME = 'vendor_processed_by'
    ) > 0,
    -- If column exists, modify it to match users.id data type
    CONCAT('ALTER TABLE `', @tablename, '` MODIFY COLUMN `vendor_processed_by` INT(11) DEFAULT NULL;'),
    -- If column doesn't exist, create it with matching data type
    'ALTER TABLE `activity_bookings` ADD COLUMN `vendor_processed_by` INT(11) DEFAULT NULL AFTER `vendor_accepted_at`;'
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Add vendor_processed_ip
SET @preparedStatement = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = @dbname 
     AND TABLE_NAME = @tablename 
     AND COLUMN_NAME = 'vendor_processed_ip'
    ) > 0,
    'SELECT 1',
    'ALTER TABLE `activity_bookings` ADD COLUMN `vendor_processed_ip` VARCHAR(45) COLLATE utf8mb4_general_ci DEFAULT NULL AFTER `vendor_processed_by`;'
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Add vendor_processed_user_agent
SET @preparedStatement = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = @dbname 
     AND TABLE_NAME = @tablename 
     AND COLUMN_NAME = 'vendor_processed_user_agent'
    ) > 0,
    'SELECT 1',
    'ALTER TABLE `activity_bookings` ADD COLUMN `vendor_processed_user_agent` VARCHAR(255) COLLATE utf8mb4_general_ci DEFAULT NULL AFTER `vendor_processed_ip`;'
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- 2. Add indexes if they don't exist
SET @preparedStatement = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS 
     WHERE TABLE_SCHEMA = @dbname 
     AND TABLE_NAME = @tablename 
     AND INDEX_NAME = 'idx_vendor_pay_status'
    ) > 0,
    'SELECT 1',
    'CREATE INDEX `idx_vendor_pay_status` ON `activity_bookings` (`vendor_pay_status`);'
));
PREPARE createIndexIfNotExists FROM @preparedStatement;
EXECUTE createIndexIfNotExists;
DEALLOCATE PREPARE createIndexIfNotExists;

-- 3. Add foreign key constraint if it doesn't exist
-- First, ensure the column exists and has the correct data type
SET @preparedStatement = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = @dbname 
     AND TABLE_NAME = @tablename 
     AND COLUMN_NAME = 'vendor_processed_by'
    ) > 0,
    -- If column exists, proceed with adding the constraint
    IF(
        (SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS 
         WHERE CONSTRAINT_SCHEMA = @dbname 
         AND TABLE_NAME = @tablename 
         AND CONSTRAINT_NAME = 'fk_activity_bookings_processed_by'
        ) > 0,
        'SELECT 1',
        'ALTER TABLE `activity_bookings` ADD CONSTRAINT `fk_activity_bookings_processed_by` FOREIGN KEY (`vendor_processed_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;'
    ),
    'SELECT 1' -- Skip if column doesn't exist (shouldn't happen as we just created it)
));
PREPARE addFkIfNotExists FROM @preparedStatement;
EXECUTE addFkIfNotExists;
DEALLOCATE PREPARE addFkIfNotExists;
