-- 2025-09-14: Mail system core tables (settings, queue, logs, suppressions)
START TRANSACTION;

CREATE TABLE IF NOT EXISTS mail_settings (
  id TINYINT UNSIGNED NOT NULL PRIMARY KEY DEFAULT 1,
  active_provider ENUM('ses','sendgrid','smtp') NOT NULL DEFAULT 'smtp',
  from_name VARCHAR(100) NOT NULL DEFAULT 'B2B Travel',
  from_email VARCHAR(150) NOT NULL DEFAULT 'noreply@example.com',
  reply_to_email VARCHAR(150) DEFAULT NULL,
  bcc_list VARCHAR(255) DEFAULT NULL,
  -- SES
  ses_region VARCHAR(50) DEFAULT NULL,
  ses_smtp_username VARCHAR(120) DEFAULT NULL,
  ses_smtp_password VARCHAR(180) DEFAULT NULL,
  -- SendGrid
  sendgrid_api_key VARCHAR(255) DEFAULT NULL,
  -- SMTP generic
  smtp_host VARCHAR(150) DEFAULT NULL,
  smtp_port SMALLINT UNSIGNED DEFAULT 587,
  smtp_username VARCHAR(120) DEFAULT NULL,
  smtp_password VARCHAR(180) DEFAULT NULL,
  smtp_encryption ENUM('none','ssl','tls') NOT NULL DEFAULT 'tls',
  -- Per-notification toggles
  enable_taxi_vendor TINYINT(1) NOT NULL DEFAULT 1,
  enable_taxi_agent TINYINT(1) NOT NULL DEFAULT 1,
  enable_taxi_internal TINYINT(1) NOT NULL DEFAULT 1,
  enable_hotel_vendor TINYINT(1) NOT NULL DEFAULT 1,
  enable_hotel_agent TINYINT(1) NOT NULL DEFAULT 1,
  enable_hotel_internal TINYINT(1) NOT NULL DEFAULT 1,
  enable_activity_vendor TINYINT(1) NOT NULL DEFAULT 1,
  enable_activity_agent TINYINT(1) NOT NULL DEFAULT 1,
  enable_activity_internal TINYINT(1) NOT NULL DEFAULT 1,
  updated_at TIMESTAMP NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO mail_settings (id) VALUES (1)
  ON DUPLICATE KEY UPDATE id = id;

CREATE TABLE IF NOT EXISTS mail_queue (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  event_key VARCHAR(120) NOT NULL,
  audience ENUM('vendor','agent','internal') NOT NULL,
  module ENUM('taxi','hotel','activity','evisa','system') NOT NULL,
  booking_id INT(11) DEFAULT NULL,
  to_email VARCHAR(150) NOT NULL,
  subject VARCHAR(200) NOT NULL,
  html MEDIUMTEXT NOT NULL,
  locale VARCHAR(10) DEFAULT 'en',
  status ENUM('queued','processing','sent','failed') NOT NULL DEFAULT 'queued',
  attempt_count TINYINT UNSIGNED NOT NULL DEFAULT 0,
  last_error VARCHAR(500) DEFAULT NULL,
  created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NULL DEFAULT NULL,
  PRIMARY KEY (id),
  KEY idx_status (status),
  KEY idx_booking (booking_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS mail_logs (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  queue_id BIGINT UNSIGNED DEFAULT NULL,
  booking_id INT(11) DEFAULT NULL,
  module ENUM('taxi','hotel','activity','evisa','system') NOT NULL,
  audience ENUM('vendor','agent','internal') NOT NULL,
  provider ENUM('ses','sendgrid','smtp') NOT NULL,
  to_email VARCHAR(150) NOT NULL,
  subject VARCHAR(200) NOT NULL,
  status ENUM('sent','failed') NOT NULL,
  message_id VARCHAR(180) DEFAULT NULL,
  error_text VARCHAR(500) DEFAULT NULL,
  created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY idx_booking (booking_id),
  KEY idx_provider_status (provider,status)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS mail_suppressions (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  email VARCHAR(150) NOT NULL,
  type ENUM('bounce','complaint','unsubscribe') NOT NULL,
  provider ENUM('ses','sendgrid') DEFAULT NULL,
  meta JSON DEFAULT NULL,
  created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  UNIQUE KEY uniq_email_type (email,type)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

COMMIT;
