-- Add IP address and other useful fields to support_tickets
ALTER TABLE `support_tickets` 
  ADD COLUMN `ip_address` VARCHAR(45) NULL DEFAULT NULL AFTER `user_id`,
  ADD COLUMN `last_replied_at` TIMESTAMP NULL DEFAULT NULL AFTER `updated_at`,
  ADD COLUMN `assigned_to` INT NULL DEFAULT NULL AFTER `status`,
  ADD INDEX `idx_ip` (`ip_address`),
  ADD INDEX `idx_assigned_to` (`assigned_to`);

-- Add agent_id to track who replied to tickets
ALTER TABLE `support_replies` 
  ADD COLUMN `agent_id` INT NULL DEFAULT NULL AFTER `user_id`,
  ADD INDEX `idx_agent` (`agent_id`);

-- Add foreign key for assigned_to
ALTER TABLE `support_tickets` 
  ADD CONSTRAINT `fk_ticket_agent` FOREIGN KEY (`assigned_to`) REFERENCES `users` (`id`) ON DELETE SET NULL;
