-- Add agent_id column to support_replies if it doesn't exist
SET @has_agent_id := (
  SELECT COUNT(*) FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = 'support_replies' 
  AND COLUMN_NAME = 'agent_id'
);

SET @sql := IF(@has_agent_id > 0,
  'SELECT 1',
  'ALTER TABLE support_replies ADD COLUMN agent_id INT NULL AFTER user_id'
);
PREPARE stmt FROM @sql; 
EXECUTE stmt; 
DEALLOCATE PREPARE stmt;

-- Add foreign key for agent_id
SET @has_fk_agent := (
  SELECT COUNT(*) 
  FROM information_schema.TABLE_CONSTRAINTS 
  WHERE CONSTRAINT_SCHEMA = DATABASE()
  AND TABLE_NAME = 'support_replies' 
  AND CONSTRAINT_NAME = 'fk_replies_agent'
);

SET @sql2 := IF(@has_fk_agent > 0,
  'SELECT 1',
  'ALTER TABLE support_replies ADD CONSTRAINT fk_replies_agent FOREIGN KEY (agent_id) REFERENCES agents(id) ON DELETE SET NULL'
);
PREPARE stmt2 FROM @sql2; 
EXECUTE stmt2; 
DEALLOCATE PREPARE stmt2;

-- Update existing admin replies to have role='admin'
UPDATE support_replies SET role = 'admin' WHERE role = 'admin';

-- Add index for better performance on common queries
CREATE INDEX IF NOT EXISTS idx_replies_ticket_role ON support_replies(ticket_id, role);
CREATE INDEX IF NOT EXISTS idx_replies_created ON support_replies(created_at DESC);
