-- Ensure support_replies.role supports 'admin' and support_tickets has last_replied_at

-- Add 'admin' to support_replies.role ENUM if missing
SET @has_admin := (
  SELECT CASE WHEN COLUMN_TYPE LIKE "%,'admin'%" OR COLUMN_TYPE LIKE "enum('admin',%" OR COLUMN_TYPE LIKE "enum('%,'admin')" THEN 1 ELSE 0 END
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'support_replies' AND COLUMN_NAME = 'role'
);

-- Only modify ENUM if 'admin' not present
SET @sql := IF(@has_admin = 1,
  'SELECT 1',
  'ALTER TABLE support_replies MODIFY COLUMN role ENUM(\'user\', \'agent\', \'admin\') NOT NULL'
);
PREPARE stmt FROM @sql; EXECUTE stmt; DEALLOCATE PREPARE stmt;

-- Ensure support_tickets.last_replied_at column exists
SET @has_last_replied := (
  SELECT COUNT(*) FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'support_tickets' AND COLUMN_NAME = 'last_replied_at'
);

SET @sql2 := IF(@has_last_replied > 0,
  'SELECT 1',
  'ALTER TABLE support_tickets ADD COLUMN last_replied_at TIMESTAMP NULL DEFAULT NULL AFTER updated_at'
);
PREPARE stmt2 FROM @sql2; EXECUTE stmt2; DEALLOCATE PREPARE stmt2;

-- Optional: normalize existing rows where last_replied_at is NULL to updated_at (best effort)
UPDATE support_tickets SET last_replied_at = COALESCE(last_replied_at, updated_at) WHERE last_replied_at IS NULL;
