-- Company-owned bank accounts for assigning to agent wallet deposits
CREATE TABLE IF NOT EXISTS `company_bank_accounts` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `bank_name` VARCHAR(120) NOT NULL,
  `account_name` VARCHAR(150) NOT NULL,
  `account_number` VARCHAR(64) NOT NULL,
  `branch` VARCHAR(120) DEFAULT NULL,
  `swift_code` VARCHAR(20) DEFAULT NULL,
  `ifsc` VARCHAR(20) DEFAULT NULL,
  `currency` CHAR(3) NOT NULL DEFAULT 'THB',
  `active` TINYINT(1) NOT NULL DEFAULT 1,
  `notes` VARCHAR(255) DEFAULT NULL,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_company_bank_account` (`bank_name`,`account_number`,`currency`),
  KEY `idx_active_currency` (`active`,`currency`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;