-- 2025-09-10: Vendor payout tracking for taxi bookings (resilient to missing vendor_currency)
START TRANSACTION;

SET @dbname = DATABASE();
SET @after_col = (SELECT IF(
  (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
   WHERE TABLE_SCHEMA=@dbname AND TABLE_NAME='taxi_bookings' AND COLUMN_NAME='vendor_currency') > 0,
  'vendor_currency',
  'amount_total'
));

-- Add vendor_pay_status
SET @sql1 = CONCAT('ALTER TABLE taxi_bookings ADD COLUMN IF NOT EXISTS vendor_pay_status ENUM(''pending'',''cleared'') NOT NULL DEFAULT ''pending'' AFTER ', @after_col);
PREPARE stmt1 FROM @sql1; EXECUTE stmt1; DEALLOCATE PREPARE stmt1;

-- Add vendor_paid_at
SET @sql2 = 'ALTER TABLE taxi_bookings ADD COLUMN IF NOT EXISTS vendor_paid_at DATETIME NULL AFTER vendor_pay_status';
PREPARE stmt2 FROM @sql2; EXECUTE stmt2; DEALLOCATE PREPARE stmt2;

-- Add vendor_invoice_no
SET @sql3 = 'ALTER TABLE taxi_bookings ADD COLUMN IF NOT EXISTS vendor_invoice_no VARCHAR(50) NULL AFTER vendor_paid_at';
PREPARE stmt3 FROM @sql3; EXECUTE stmt3; DEALLOCATE PREPARE stmt3;

-- Add vendor_pay_note
SET @sql4 = 'ALTER TABLE taxi_bookings ADD COLUMN IF NOT EXISTS vendor_pay_note VARCHAR(255) NULL AFTER vendor_invoice_no';
PREPARE stmt4 FROM @sql4; EXECUTE stmt4; DEALLOCATE PREPARE stmt4;

-- Initialize pay status for already paid bookings
UPDATE taxi_bookings
SET vendor_pay_status = COALESCE(vendor_pay_status, 'pending')
WHERE payment_status = 'paid' AND (vendor_pay_status IS NULL OR vendor_pay_status = '');

COMMIT;
