778542878\77-- 2025-09-10: Create taxi_pricing table used by Admin > Taxis pricing forms
START TRANSACTION;

CREATE TABLE IF NOT EXISTS taxi_pricing (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  taxi_id INT UNSIGNED NOT NULL,
  model ENUM('fixed','distance','hourly') NOT NULL DEFAULT 'fixed',
  currency VARCHAR(8) NOT NULL DEFAULT 'THB',
  base_fare DECIMAL(10,2) NULL,
  per_km DECIMAL(10,2) NULL,
  per_hour DECIMAL(10,2) NULL,
  wait_per_hour DECIMAL(10,2) NULL,
  tax_pct DECIMAL(6,2) NULL,
  fee_pct DECIMAL(6,2) NULL,
  vendor_cost DECIMAL(10,2) NULL,
  agent_price DECIMAL(10,2) NULL,
  customer_price DECIMAL(10,2) NULL,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  UNIQUE KEY uniq_taxi (taxi_id),
  KEY idx_taxi (taxi_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

COMMIT;
