-- Backfill vendor_id on taxi_bookings from taxis.vendor_id where missing
START TRANSACTION;

UPDATE taxi_bookings b
JOIN taxis t ON t.id = b.taxi_id
SET b.vendor_id = t.vendor_id,
    b.vendor_assigned_at = IFNULL(b.vendor_assigned_at, NOW())
WHERE b.vendor_id IS NULL
  AND t.vendor_id IS NOT NULL;

COMMIT;
