-- Add vendor_id column to users table if it doesn't exist
SET @dbname = DATABASE();
SET @tablename = 'users';
SET @columnname = 'vendor_id';
SET @preparedStatement = (SELECT IF(
    (
        SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
        WHERE (table_name = @tablename AND column_name = @columnname AND table_schema = @dbname)
    ) = 0,
    CONCAT('ALTER TABLE `', @tablename, '` ADD COLUMN `', @columnname, '` INT NULL DEFAULT NULL AFTER `partner_id`'),
    'SELECT 1'
));

PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Add index on vendor_id if it doesn't exist
SET @indexname = 'idx_users_vendor_id';
SET @preparedStatement = (SELECT IF(
    (
        SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS
        WHERE (table_name = @tablename AND index_name = @indexname AND table_schema = @dbname)
    ) = 0,
    CONCAT('CREATE INDEX `', @indexname, '` ON `', @tablename, '` (`vendor_id`)'),
    'SELECT 1'
));

PREPARE createIndexIfNotExists FROM @preparedStatement;
EXECUTE createIndexIfNotExists;
DEALLOCATE PREPARE createIndexIfNotExists;

-- Update existing vendor users to link to their vendor records
UPDATE users u
JOIN vendors v ON u.email = v.contact_email
SET u.vendor_id = v.id
WHERE u.role = 'Vendor' AND u.vendor_id IS NULL;

-- Add foreign key constraint if it doesn't exist
SET @constraintname = 'fk_users_vendor_id';
SET @preparedStatement = (SELECT IF(
    (
        SELECT COUNT(*) FROM information_schema.TABLE_CONSTRAINTS
        WHERE (constraint_schema = @dbname AND table_name = @tablename AND constraint_name = @constraintname)
    ) = 0,
    'ALTER TABLE `users` ADD CONSTRAINT `fk_users_vendor_id` FOREIGN KEY (`vendor_id`) REFERENCES `vendors` (`id`) ON DELETE SET NULL ON UPDATE CASCADE',
    'SELECT 1'
));

PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Verify the changes
SELECT 
    u.id AS user_id, 
    u.email, 
    u.role, 
    u.vendor_id, 
    v.name AS vendor_name,
    v.contact_email AS vendor_contact_email
FROM users u
LEFT JOIN vendors v ON u.vendor_id = v.id
WHERE u.role = 'Vendor';
