-- Add vendor_id column to users table
ALTER TABLE `users` 
ADD COLUMN `vendor_id` INT NULL DEFAULT NULL AFTER `partner_id`,
ADD INDEX `idx_users_vendor_id` (`vendor_id`);

-- Add foreign key constraint
ALTER TABLE `users`
ADD CONSTRAINT `fk_users_vendor_id`
  FOREIGN KEY (`vendor_id`)
  REFERENCES `vendors` (`id`)
  ON DELETE SET NULL
  ON UPDATE CASCADE;

-- Update existing vendor users to link to their vendor records
UPDATE users u
JOIN vendors v ON u.email = v.contact_email
SET u.vendor_id = v.id
WHERE u.role = 'Vendor';

-- Verify the changes
SELECT u.id, u.email, u.role, u.vendor_id, v.name as vendor_name
FROM users u
LEFT JOIN vendors v ON u.vendor_id = v.id
WHERE u.role = 'Vendor';
