-- Add location fields to taxi_bookings table
ALTER TABLE `taxi_bookings`
ADD COLUMN `pickup_location` VARCHAR(200) NULL AFTER `to_text`,
ADD COLUMN `pickup_landmark` VARCHAR(200) NULL AFTER `pickup_location`,
ADD COLUMN `dropoff_location` VARCHAR(200) NULL AFTER `pickup_landmark`,
ADD COLUMN `dropoff_landmark` VARCHAR(200) NULL AFTER `dropoff_location`,
ADD COLUMN `notes` TEXT NULL AFTER `dropoff_landmark`;

-- Backfill existing data from from_text/to_text
UPDATE `taxi_bookings` 
SET 
  `pickup_location` = `from_text`,
  `dropoff_location` = `to_text`
WHERE `pickup_location` IS NULL OR `dropoff_location` IS NULL;
