-- 2025-09-09: Taxi Itineraries schema and booking snapshots
START TRANSACTION;

-- Templates
CREATE TABLE IF NOT EXISTS taxi_itineraries (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  vendor_id INT UNSIGNED NULL,
  taxi_id INT UNSIGNED NULL,
  name VARCHAR(160) NOT NULL,
  description TEXT NULL,
  active TINYINT(1) NOT NULL DEFAULT 1,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY idx_vendor (vendor_id),
  KEY idx_taxi (taxi_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS taxi_itinerary_stops (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  itinerary_id INT UNSIGNED NOT NULL,
  seq INT UNSIGNED NOT NULL DEFAULT 1,
  label VARCHAR(200) NOT NULL,
  address VARCHAR(300) NULL,
  wait_minutes INT UNSIGNED NULL,
  extra_price DECIMAL(10,2) NULL,
  notes VARCHAR(300) NULL,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY idx_itinerary (itinerary_id),
  CONSTRAINT fk_ti_stop_itin FOREIGN KEY (itinerary_id) REFERENCES taxi_itineraries(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Booking snapshots on payment intents and final bookings
ALTER TABLE taxi_payment_intents
  ADD COLUMN IF NOT EXISTS itinerary_id INT UNSIGNED NULL AFTER drop_address,
  ADD COLUMN IF NOT EXISTS itinerary_name VARCHAR(200) NULL AFTER itinerary_id,
  ADD COLUMN IF NOT EXISTS itinerary_json JSON NULL AFTER itinerary_name;

ALTER TABLE taxi_bookings
  ADD COLUMN IF NOT EXISTS itinerary_id INT UNSIGNED NULL AFTER drop_address,
  ADD COLUMN IF NOT EXISTS itinerary_name VARCHAR(200) NULL AFTER itinerary_id,
  ADD COLUMN IF NOT EXISTS itinerary_json JSON NULL AFTER itinerary_name;

COMMIT;
