-- 2025-09-09: Enhance Taxi schema for professional pickup/drop and customer + round-trip details
START TRANSACTION;

-- Ensure taxis has capacity column
ALTER TABLE taxis
  ADD COLUMN IF NOT EXISTS capacity INT UNSIGNED NULL AFTER vehicle_type;
-- Trip type: single, round, or both (default)
ALTER TABLE taxis
  ADD COLUMN IF NOT EXISTS trip_type ENUM('single','round','both') NOT NULL DEFAULT 'both' AFTER route;

-- Enrich taxi_payment_intents with structured pickup/drop, customer, and round-trip fields
ALTER TABLE taxi_payment_intents
  ADD COLUMN IF NOT EXISTS pickup_type ENUM('airport','hotel','apartment','address') NULL AFTER trip_date,
  ADD COLUMN IF NOT EXISTS drop_type   ENUM('airport','hotel','apartment','address') NULL AFTER pickup_type,
  ADD COLUMN IF NOT EXISTS pickup_airport_code VARCHAR(10) NULL AFTER drop_type,
  ADD COLUMN IF NOT EXISTS drop_airport_code   VARCHAR(10) NULL AFTER pickup_airport_code,
  ADD COLUMN IF NOT EXISTS pickup_hotel_name   VARCHAR(200) NULL AFTER drop_airport_code,
  ADD COLUMN IF NOT EXISTS pickup_hotel_address VARCHAR(300) NULL AFTER pickup_hotel_name,
  ADD COLUMN IF NOT EXISTS pickup_apartment_name VARCHAR(200) NULL AFTER pickup_hotel_address,
  ADD COLUMN IF NOT EXISTS pickup_apartment_address VARCHAR(300) NULL AFTER pickup_apartment_name,
  ADD COLUMN IF NOT EXISTS pickup_address      VARCHAR(300) NULL AFTER pickup_apartment_address,
  ADD COLUMN IF NOT EXISTS drop_hotel_name     VARCHAR(200) NULL AFTER pickup_address,
  ADD COLUMN IF NOT EXISTS drop_hotel_address  VARCHAR(300) NULL AFTER drop_hotel_name,
  ADD COLUMN IF NOT EXISTS drop_apartment_name VARCHAR(200) NULL AFTER drop_hotel_address,
  ADD COLUMN IF NOT EXISTS drop_apartment_address VARCHAR(300) NULL AFTER drop_apartment_name,
  ADD COLUMN IF NOT EXISTS drop_address        VARCHAR(300) NULL AFTER drop_apartment_address,
  ADD COLUMN IF NOT EXISTS customer_name       VARCHAR(120) NULL AFTER to_text,
  ADD COLUMN IF NOT EXISTS customer_email      VARCHAR(160) NULL AFTER customer_name,
  ADD COLUMN IF NOT EXISTS customer_phone      VARCHAR(40)  NULL AFTER customer_email,
  ADD COLUMN IF NOT EXISTS is_round_trip TINYINT(1) NOT NULL DEFAULT 0 AFTER customer_phone,
  ADD COLUMN IF NOT EXISTS return_date DATE NULL AFTER is_round_trip,
  ADD COLUMN IF NOT EXISTS return_time VARCHAR(10) NULL AFTER return_date;

-- Enrich taxi_bookings similarly
ALTER TABLE taxi_bookings
  ADD COLUMN IF NOT EXISTS pickup_type ENUM('airport','hotel','apartment','address') NULL AFTER trip_date,
  ADD COLUMN IF NOT EXISTS drop_type   ENUM('airport','hotel','apartment','address') NULL AFTER pickup_type,
  ADD COLUMN IF NOT EXISTS pickup_airport_code VARCHAR(10) NULL AFTER drop_type,
  ADD COLUMN IF NOT EXISTS drop_airport_code   VARCHAR(10) NULL AFTER pickup_airport_code,
  ADD COLUMN IF NOT EXISTS pickup_hotel_name   VARCHAR(200) NULL AFTER drop_airport_code,
  ADD COLUMN IF NOT EXISTS pickup_hotel_address VARCHAR(300) NULL AFTER pickup_hotel_name,
  ADD COLUMN IF NOT EXISTS pickup_apartment_name VARCHAR(200) NULL AFTER pickup_hotel_address,
  ADD COLUMN IF NOT EXISTS pickup_apartment_address VARCHAR(300) NULL AFTER pickup_apartment_name,
  ADD COLUMN IF NOT EXISTS pickup_address      VARCHAR(300) NULL AFTER pickup_apartment_address,
  ADD COLUMN IF NOT EXISTS drop_hotel_name     VARCHAR(200) NULL AFTER pickup_address,
  ADD COLUMN IF NOT EXISTS drop_hotel_address  VARCHAR(300) NULL AFTER drop_hotel_name,
  ADD COLUMN IF NOT EXISTS drop_apartment_name VARCHAR(200) NULL AFTER drop_hotel_address,
  ADD COLUMN IF NOT EXISTS drop_apartment_address VARCHAR(300) NULL AFTER drop_apartment_name,
  ADD COLUMN IF NOT EXISTS drop_address        VARCHAR(300) NULL AFTER drop_apartment_address,
  ADD COLUMN IF NOT EXISTS customer_name       VARCHAR(120) NULL AFTER to_text,
  ADD COLUMN IF NOT EXISTS customer_email      VARCHAR(160) NULL AFTER customer_name,
  ADD COLUMN IF NOT EXISTS customer_phone      VARCHAR(40)  NULL AFTER customer_email,
  ADD COLUMN IF NOT EXISTS is_round_trip TINYINT(1) NOT NULL DEFAULT 0 AFTER customer_phone,
  ADD COLUMN IF NOT EXISTS return_date DATE NULL AFTER is_round_trip,
  ADD COLUMN IF NOT EXISTS return_time VARCHAR(10) NULL AFTER return_date;

-- Optional lookups: airports master
CREATE TABLE IF NOT EXISTS airports (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  code VARCHAR(10) NOT NULL,
  name VARCHAR(200) NOT NULL,
  city VARCHAR(120) NULL,
  country VARCHAR(120) NULL,
  PRIMARY KEY(id),
  UNIQUE KEY uq_airport_code (code)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

COMMIT;
