-- Hotel Booking + Wallet Core Schema Patch
-- Created: 2025-09-04 02:57:40+07:00
-- Charset/Engine: utf8mb4/innodb

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS=0;

-- 1) hotel_rooms: referenced by bookings and allocations
CREATE TABLE IF NOT EXISTS `hotel_rooms` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hotel_id` int unsigned NOT NULL,
  `name` varchar(120) NOT NULL,
  `occupancy_adults` int NOT NULL DEFAULT 2,
  `occupancy_children` int NOT NULL DEFAULT 0,
  `size_sqm` int DEFAULT NULL,
  `bed_info` varchar(120) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `capacity` int NOT NULL DEFAULT 2,
  PRIMARY KEY (`id`),
  KEY `idx_hotel_rooms_hotel_id` (`hotel_id`),
  KEY `idx_hotel_rooms_active` (`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 2) room_allocations: availability per room/date used during validation
CREATE TABLE IF NOT EXISTS `room_allocations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `room_id` int unsigned NOT NULL,
  `date` date NOT NULL,
  `allotment` int NOT NULL DEFAULT 0,
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_room_date` (`room_id`,`date`),
  KEY `idx_room_allocations_closed` (`closed`),
  CONSTRAINT `fk_room_allocations_room` FOREIGN KEY (`room_id`) REFERENCES `hotel_rooms` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 3) hotel_bookings: created pending/unpaid then confirmed/paid after wallet debit
CREATE TABLE IF NOT EXISTS `hotel_bookings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hotel_id` int unsigned NOT NULL,
  `vendor_id` int unsigned NOT NULL DEFAULT 0,
  `booking_code` varchar(40) NOT NULL,
  `checkin` date NOT NULL,
  `checkout` date NOT NULL,
  `nights` int NOT NULL,
  `room_id` int unsigned NOT NULL,
  `rate_plan_id` int unsigned DEFAULT NULL,
  `rooms_qty` int NOT NULL DEFAULT 1,
  `guests_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`guests_json`)),
  `customer_name` varchar(150) NOT NULL,
  `customer_email` varchar(150) DEFAULT NULL,
  `status` enum('pending','confirmed','cancelled') NOT NULL DEFAULT 'pending',
  `total_price` decimal(12,2) NOT NULL,
  `currency` char(3) NOT NULL DEFAULT 'THB',
  `payment_status` enum('unpaid','paid','refunded') NOT NULL DEFAULT 'unpaid',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_booking_code` (`booking_code`),
  KEY `idx_bookings_hotel` (`hotel_id`),
  KEY `idx_bookings_room` (`room_id`),
  KEY `idx_bookings_status` (`status`),
  KEY `idx_bookings_dates` (`checkin`,`checkout`),
  CONSTRAINT `fk_bookings_room` FOREIGN KEY (`room_id`) REFERENCES `hotel_rooms` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 4) wallets: one per user (B2B agent, etc.)
CREATE TABLE IF NOT EXISTS `wallets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `balance` decimal(12,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_wallet_user` (`user_id`),
  KEY `idx_wallet_balance` (`balance`)
  -- Note: FK to users omitted if legacy data uses placeholder users. Add if safe:
  -- ,CONSTRAINT `fk_wallet_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 5) wallet_ledger: immutable audit trail of wallet movements
CREATE TABLE IF NOT EXISTS `wallet_ledger` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `wallet_id` int unsigned NOT NULL,
  `type` enum('credit','debit') NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `method` enum('stripe','manual') NOT NULL,
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`meta`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_ledger_wallet` (`wallet_id`),
  KEY `idx_ledger_type` (`type`),
  KEY `idx_ledger_status` (`status`),
  CONSTRAINT `fk_ledger_wallet` FOREIGN KEY (`wallet_id`) REFERENCES `wallets` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 6) payment_intents: stores draft payloads for off-session (webhook) capture
CREATE TABLE IF NOT EXISTS `payment_intents` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `gateway` enum('stripe') NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `currency` varchar(8) NOT NULL DEFAULT 'THB',
  `provider_intent_id` varchar(191) DEFAULT NULL,
  `status` enum('created','succeeded','failed','expired') NOT NULL DEFAULT 'created',
  `payload_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`payload_json`)),
  `result_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`result_json`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `processed_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_pi_user` (`user_id`),
  KEY `idx_pi_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

SET FOREIGN_KEY_CHECKS=1;
