-- 2025-09-03_payments_fix.sql
-- Ensure payments table has required columns used by PaymentsController
-- Safe to run multiple times.

-- Add missing user_id column if not exists
SET @has_user_id := (
  SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payments' AND COLUMN_NAME = 'user_id'
);
SET @sql_user_id := IF(@has_user_id = 0,
  'ALTER TABLE payments ADD COLUMN user_id BIGINT UNSIGNED NOT NULL DEFAULT 0 AFTER order_id, ADD KEY idx_payments_user (user_id)',
  'SELECT 1');
PREPARE stmt1 FROM @sql_user_id; EXECUTE stmt1; DEALLOCATE PREPARE stmt1;

-- Add missing session_url if not exists
SET @has_session_url := (
  SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payments' AND COLUMN_NAME = 'session_url'
);
SET @sql_session_url := IF(@has_session_url = 0,
  'ALTER TABLE payments ADD COLUMN session_url TEXT NULL AFTER idempotency_key',
  'SELECT 1');
PREPARE stmt2 FROM @sql_session_url; EXECUTE stmt2; DEALLOCATE PREPARE stmt2;

-- Add missing raw_session if not exists
SET @has_raw_session := (
  SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payments' AND COLUMN_NAME = 'raw_session'
);
SET @sql_raw_session := IF(@has_raw_session = 0,
  'ALTER TABLE payments ADD COLUMN raw_session JSON NULL AFTER session_url',
  'SELECT 1');
PREPARE stmt3 FROM @sql_raw_session; EXECUTE stmt3; DEALLOCATE PREPARE stmt3;

-- Add missing event_id unique key if not exists
SET @has_event_id := (
  SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payments' AND COLUMN_NAME = 'event_id'
);
SET @has_event_id_unique := (
  SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payments' AND INDEX_NAME = 'uq_payments_event_id'
);
SET @sql_event_id_idx := IF(@has_event_id > 0 AND @has_event_id_unique = 0,
  'ALTER TABLE payments ADD UNIQUE KEY uq_payments_event_id (event_id)',
  'SELECT 1');
PREPARE stmt4 FROM @sql_event_id_idx; EXECUTE stmt4; DEALLOCATE PREPARE stmt4;

-- Add missing idempotency_key unique key if not exists
SET @has_idem := (
  SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payments' AND COLUMN_NAME = 'idempotency_key'
);
SET @has_idem_unique := (
  SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payments' AND INDEX_NAME = 'uq_payments_idem'
);
SET @sql_idem_idx := IF(@has_idem > 0 AND @has_idem_unique = 0,
  'ALTER TABLE payments ADD UNIQUE KEY uq_payments_idem (idempotency_key)',
  'SELECT 1');
PREPARE stmt5 FROM @sql_idem_idx; EXECUTE stmt5; DEALLOCATE PREPARE stmt5;
