-- Patch: Add optional thumbnail and coordinates to hotels for agent portal UI
-- Authoritative schema reference: database/patches/b2b_travel.sql
-- Safe to run multiple times on MySQL 8.0+ using IF NOT EXISTS. On older MySQL, run manually with column existence checks.

ALTER TABLE `hotels`
  ADD COLUMN IF NOT EXISTS `thumbnail_url` VARCHAR(1024) NULL AFTER `name`,
  ADD COLUMN IF NOT EXISTS `latitude` DECIMAL(10,7) NULL AFTER `city`,
  ADD COLUMN IF NOT EXISTS `longitude` DECIMAL(10,7) NULL AFTER `latitude`;

-- Optional: simple index to support map queries
CREATE INDEX IF NOT EXISTS `idx_hotels_lat_lng` ON `hotels` (`latitude`, `longitude`);
