-- 2025-09-03: Add hotel booking cancellation requests table

CREATE TABLE IF NOT EXISTS `hotel_booking_cancel_requests` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `hotel_booking_id` INT(11) NOT NULL,
  `user_id` INT(11) NOT NULL, -- agent user id
  `reason` TEXT NOT NULL,
  `status` ENUM('requested','approved','rejected','cancelled') NOT NULL DEFAULT 'requested',
  `resolution_notes` TEXT DEFAULT NULL,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_booking` (`hotel_booking_id`),
  KEY `idx_user` (`user_id`),
  KEY `idx_status` (`status`),
  CONSTRAINT `fk_hbcr_hotel_booking` FOREIGN KEY (`hotel_booking_id`) REFERENCES `hotel_bookings` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_hbcr_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Optional helper: prevent multiple open requests for the same booking at the same time via application logic.
