-- database/patches/2025-09-01_yachts.sql
-- Introduce yachts and yacht_images tables for B2B agent yachts module
-- Safe to run multiple times

START TRANSACTION;

-- Yachts main table
CREATE TABLE IF NOT EXISTS `yachts` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `subtitle` VARCHAR(255) NULL,
  `city` VARCHAR(120) NULL,
  `capacity` INT NULL,
  `max_guests` INT NULL,
  `from_price` DECIMAL(10,2) DEFAULT 0.00,
  `booking_code` VARCHAR(40) NULL,
  `vendor_cost` DECIMAL(10,2) NULL DEFAULT NULL,
  `agent_cost` DECIMAL(10,2) NULL DEFAULT NULL,
  `customer_cost` DECIMAL(10,2) NULL DEFAULT NULL,
  `visible_agent` TINYINT(1) NOT NULL DEFAULT 1,
  `currency` CHAR(3) NOT NULL DEFAULT 'THB',
  `active` TINYINT(1) NOT NULL DEFAULT 1,
  `created_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_yachts_city_active` (`city`,`active`),
  KEY `idx_yachts_booking_code` (`booking_code`),
  KEY `idx_yachts_visible_agent` (`visible_agent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Yacht images table
CREATE TABLE IF NOT EXISTS `yacht_images` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `yacht_id` INT UNSIGNED NOT NULL,
  `file_path` VARCHAR(500) NOT NULL,
  `is_cover` TINYINT(1) NOT NULL DEFAULT 0,
  `created_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_yacht_images_yacht` (`yacht_id`),
  CONSTRAINT `fk_yacht_images_yacht` FOREIGN KEY (`yacht_id`) REFERENCES `yachts`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

COMMIT;
