-- Patch: Add hotel stays per package variant and vehicle info for auto-switching
-- Date: 2025-09-01
-- Note: Designed to be idempotent.

START TRANSACTION;

-- 1) Create vendor_package_stays table (if not exists)
CREATE TABLE IF NOT EXISTS `vendor_package_stays` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `package_id` int(11) NOT NULL,
  `variant_id` int(11) NOT NULL,
  `day_index` int(11) NOT NULL DEFAULT 1 COMMENT '1-based sequence within the package itinerary',
  `hotel_id` int(11) NOT NULL COMMENT 'References hotels.id',
  `nights` int(11) NOT NULL DEFAULT 1,
  `room_type` varchar(100) DEFAULT NULL,
  `include_breakfast` tinyint(1) NOT NULL DEFAULT 0,
  `notes` varchar(255) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_variant_day` (`variant_id`,`day_index`),
  KEY `idx_hotel` (`hotel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 2) Add vehicle_type and max_pax to vendor_package_prices for auto-switching by pax
-- vehicle_type is informational for UI and reporting; selection logic still based on min_quantity tiers
ALTER TABLE `vendor_package_prices`
  ADD COLUMN IF NOT EXISTS `vehicle_type` enum('none','taxi','van','minibus','bus') NULL DEFAULT NULL AFTER `pickup_notes`,
  ADD COLUMN IF NOT EXISTS `max_pax` int(11) NULL DEFAULT NULL AFTER `vehicle_type`;

COMMIT;
