ism-- Patch: 2025-09-01_hotels_filters.sql
-- Adds hotel filter capabilities (amenities, flags, geo, reviews)
-- Safe to run multiple times (guards included)

START TRANSACTION;

-- 1) Amenities master and mapping
CREATE TABLE IF NOT EXISTS `amenities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(60) NOT NULL,
  `name` varchar(120) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `hotel_amenities` (
  `hotel_id` int(11) NOT NULL,
  `amenity_id` int(11) NOT NULL,
  PRIMARY KEY (`hotel_id`,`amenity_id`),
  KEY `idx_hotel_amenity` (`amenity_id`),
  CONSTRAINT `fk_hotel_amenities_hotel` FOREIGN KEY (`hotel_id`) REFERENCES `hotels`(`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_hotel_amenities_amenity` FOREIGN KEY (`amenity_id`) REFERENCES `amenities`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- seed a few common amenities if empty
INSERT INTO `amenities` (`code`,`name`)
SELECT * FROM (
  SELECT 'wifi','Free WiFi' UNION ALL
  SELECT 'pool','Swimming pool' UNION ALL
  SELECT 'parking','Parking' UNION ALL
  SELECT 'spa','Spa' UNION ALL
  SELECT 'gym','Fitness center'
) AS s
WHERE NOT EXISTS (SELECT 1 FROM `amenities` LIMIT 1);

-- 2) Extend hotels for geo, review, payment flags, neighborhood
ALTER TABLE `hotels`
  ADD COLUMN IF NOT EXISTS `lat` decimal(9,6) NULL AFTER `country`,
  ADD COLUMN IF NOT EXISTS `lng` decimal(9,6) NULL AFTER `lat`,
  ADD COLUMN IF NOT EXISTS `neighborhood` varchar(120) NULL AFTER `lng`,
  ADD COLUMN IF NOT EXISTS `review_score_avg` decimal(3,1) NULL AFTER `featured_agent`,
  ADD COLUMN IF NOT EXISTS `pay_at_property` tinyint(1) NOT NULL DEFAULT 0 AFTER `review_score_avg`;

-- 3) Extend hotel_policies with cancellation flags
ALTER TABLE `hotel_policies`
  ADD COLUMN IF NOT EXISTS `free_cancellation` tinyint(1) NOT NULL DEFAULT 0 AFTER `pet_policy`,
  ADD COLUMN IF NOT EXISTS `refundable_until_days` int(11) NULL AFTER `free_cancellation`;

-- 4) Register this patch
INSERT INTO `db_patches` (`filename`) VALUES ('2025-09-01_hotels_filters.sql');

COMMIT;
