-- Patch: Add featured label for customer marketplace
-- Safely add column `featured_customer_label` to `hotels` to support multiple trust labels for B2C UI.
-- Allowed values: top_choice, recommended, trusted_partner, best_value (NULL means no label)

ALTER TABLE hotels
  ADD COLUMN IF NOT EXISTS featured_customer_label VARCHAR(32) NULL AFTER featured_customer;

-- Optional: constrain to allowed values if your MySQL supports CHECK (8.0.16+)
-- ALTER TABLE hotels ADD CONSTRAINT chk_featured_customer_label
--   CHECK (featured_customer_label IN ('top_choice','recommended','trusted_partner','best_value'));

-- Helpful index for sorting and filtering featured items
CREATE INDEX IF NOT EXISTS idx_hotels_featured_customer ON hotels (featured_customer, featured_customer_label);
