-- Create table for security/audit events
CREATE TABLE IF NOT EXISTS security_audit_events (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  user_id BIGINT NULL,
  agent_id BIGINT NULL,
  order_id BIGINT NULL,
  event_type VARCHAR(100) NOT NULL,
  action VARCHAR(150) NULL,
  message TEXT NULL,
  details JSON NULL,
  route VARCHAR(255) NULL,
  method VARCHAR(10) NULL,
  ip VARCHAR(64) NULL,
  user_agent VARCHAR(255) NULL,
  status_code INT NULL,
  created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  INDEX idx_event_type_created (event_type, created_at),
  INDEX idx_user_created (user_id, created_at),
  INDEX idx_agent_created (agent_id, created_at),
  INDEX idx_order_created (order_id, created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
