-- Extend bookings to store detailed item selection and pax breakdown
ALTER TABLE bookings
  ADD COLUMN IF NOT EXISTS variant_id INT NULL AFTER item_id,
  ADD COLUMN IF NOT EXISTS price_id INT NULL AFTER variant_id,
  ADD COLUMN IF NOT EXISTS pax_type ENUM('adult','child','flat') NULL AFTER pax,
  ADD COLUMN IF NOT EXISTS adults INT NULL AFTER pax_type,
  ADD COLUMN IF NOT EXISTS children INT NULL AFTER adults,
  ADD COLUMN IF NOT EXISTS infants INT NULL AFTER children,
  ADD COLUMN IF NOT EXISTS show_time VARCHAR(8) NULL AFTER infants,
  ADD COLUMN IF NOT EXISTS details_json JSON NULL AFTER show_time;

-- Optional visit_date if required by activities later (kept nullable)
ALTER TABLE bookings
  ADD COLUMN IF NOT EXISTS visit_date DATE NULL AFTER item_id;
