<?php

use App\Core\Database\Migration;

/**
 * Safe no-op migration
 *
 * Context:
 * - The current agent OTP flow already uses the `verification_tokens` table
 *   (see AgentAuthController: type='email_otp').
 * - An earlier draft attempted to create a separate `otp_verifications` table
 *   and also mixed multi-statement SQL inside a single PDO exec, which caused
 *   syntax errors.
 *
 * Decision:
 * - Keep the existing `verification_tokens` flow. This migration does nothing.
 */
class CreateOtpVerificationsTable extends Migration
{
    public function up()
    {
        // Intentionally left blank. No schema changes required.
    }

    public function down()
    {
        // Intentionally left blank.
    }
}

