<?php

use App\Core\Database\Migration;

class AddElasticEmailColumns extends Migration
{
    public function up()
    {
        $this->pdo->exec("ALTER TABLE mail_settings 
            ADD COLUMN elasticemail_api_key VARCHAR(255) DEFAULT NULL AFTER ses_region,
            ADD COLUMN elasticemail_from_email VARCHAR(255) DEFAULT NULL AFTER elasticemail_api_key,
            ADD COLUMN elasticemail_from_name VARCHAR(100) DEFAULT NULL AFTER elasticemail_from_email");
            
        // Add Elastic Email to the list of available providers
        $this->pdo->exec("UPDATE mail_settings SET available_providers = 
            JSON_ARRAY_APPEND(COALESCE(available_providers, '[]'), '$', 'elasticemail')
            WHERE id = 1");
    }

    public function down()
    {
        $this->pdo->exec("ALTER TABLE mail_settings 
            DROP COLUMN elasticemail_api_key,
            DROP COLUMN elasticemail_from_email,
            DROP COLUMN elasticemail_from_name");
            
        // Remove Elastic Email from available providers
        $this->pdo->exec("UPDATE mail_settings SET 
            available_providers = JSON_REMOVE(
                available_providers, 
                JSON_UNQUOTE(JSON_SEARCH(available_providers, 'one', 'elasticemail'))
            ) WHERE id = 1");
    }
}
