<?php
$config = require_once 'config/config.php';
$pdo = $config['pdo'];

echo "=== CREATING TEST TRANSACTIONS ===\n\n";

// 1. Create a refund transaction for existing refunded booking
echo "1. Creating refund transaction for booking 11...\n";
try {
    $stmt = $pdo->prepare("
        INSERT INTO wallet_transactions (
            user_id, transaction_type, category, amount, 
            balance_before, balance_after, description, 
            reference_id, reference_type, status, created_at
        ) VALUES (
            10, 'credit', 'refund', 600.00,
            37050.00, 37650.00, 'Taxi Booking Refund - TAX-20250911-11',
            11, 'taxi_booking', 'completed', '2025-09-11 15:30:00'
        )
    ");
    $stmt->execute();
    echo "✓ Refund transaction created (ID: " . $pdo->lastInsertId() . ")\n";
} catch (Exception $e) {
    echo "✗ Failed to create refund: " . $e->getMessage() . "\n";
}

// 2. Create an admin credit transaction
echo "\n2. Creating admin credit transaction...\n";
try {
    $stmt = $pdo->prepare("
        INSERT INTO wallet_transactions (
            user_id, transaction_type, category, amount, 
            balance_before, balance_after, description, 
            reference_id, reference_type, admin_user_id, metadata, status, created_at
        ) VALUES (
            10, 'credit', 'admin_credit', 1000.00,
            36650.00, 37650.00, 'Admin Credit - Monthly bonus payment',
            'ADMIN_CREDIT_" . time() . "', 'admin_action', 3, 
            JSON_OBJECT('admin_note', 'Monthly performance bonus', 'bonus_type', 'performance'),
            'completed', '2025-09-10 09:00:00'
        )
    ");
    $stmt->execute();
    echo "✓ Admin credit transaction created (ID: " . $pdo->lastInsertId() . ")\n";
} catch (Exception $e) {
    echo "✗ Failed to create admin credit: " . $e->getMessage() . "\n";
}

// 3. Create another refund for a different booking
echo "\n3. Creating another refund transaction...\n";
try {
    $stmt = $pdo->prepare("
        INSERT INTO wallet_transactions (
            user_id, transaction_type, category, amount, 
            balance_before, balance_after, description, 
            reference_id, reference_type, metadata, status, created_at
        ) VALUES (
            10, 'credit', 'refund', 300.00,
            37350.00, 37650.00, 'Taxi Booking Refund - Partial cancellation',
            8, 'taxi_booking', 
            JSON_OBJECT('original_amount', 600.00, 'refund_amount', 300.00, 'refund_reason', 'Partial cancellation'),
            'completed', '2025-09-09 14:15:00'
        )
    ");
    $stmt->execute();
    echo "✓ Partial refund transaction created (ID: " . $pdo->lastInsertId() . ")\n";
} catch (Exception $e) {
    echo "✗ Failed to create partial refund: " . $e->getMessage() . "\n";
}

// 4. Verify the transactions were created
echo "\n4. Verifying created transactions...\n";
$stmt = $pdo->prepare("
    SELECT id, transaction_type, category, amount, description, created_at 
    FROM wallet_transactions 
    WHERE user_id = 10 AND category IN ('refund', 'admin_credit')
    ORDER BY created_at DESC
");
$stmt->execute();
$transactions = $stmt->fetchAll();

echo "Found " . count($transactions) . " refund/admin credit transactions:\n";
foreach ($transactions as $tx) {
    echo "  ID:{$tx['id']} {$tx['category']} ({$tx['transaction_type']}) ฿{$tx['amount']} '{$tx['description']}' {$tx['created_at']}\n";
}

echo "\n=== TESTING TRIGGERS ===\n";

// Test the updated function (without updated_at)
echo "Testing updated insert_wallet_transaction function...\n";
try {
    $stmt = $pdo->prepare("SELECT insert_wallet_transaction(10, 'credit', 'admin_credit', 50.00, 'Test function call', 'TEST_FUNC', 'admin_action', NULL, JSON_OBJECT('test', true))");
    $stmt->execute();
    $result = $stmt->fetchColumn();
    echo "✓ Function works! Transaction ID: $result\n";
    
    // Clean up
    $pdo->prepare("DELETE FROM wallet_transactions WHERE id = ?")->execute([$result]);
    $pdo->prepare("UPDATE wallets SET balance = balance - 50.00 WHERE user_id = 10")->execute();
    echo "  Test transaction cleaned up\n";
} catch (Exception $e) {
    echo "✗ Function test failed: " . $e->getMessage() . "\n";
}

echo "\nDone! Check the wallet history page now.\n";
?>
