<?php
// check_vendor2.php
require __DIR__ . '/config/config.php';

function checkVendorUser($pdo, $email) {
    echo "Checking vendor user: $email\n";
    
    // Check user exists and is a vendor
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ? AND role = 'Vendor'");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user) {
        echo "Error: No vendor user found with email: $email\n";
        return false;
    }
    
    echo "✅ Found vendor user:\n";
    echo "- ID: {$user['id']}\n";
    echo "- Name: {$user['name']}\n";
    echo "- Status: {$user['status']}\n";
    
    // Check password hash
    $password = '123456'; // Default test password
    if (password_verify($password, $user['password'])) {
        echo "✅ Password verification: SUCCESS\n";
    } else {
        echo "❌ Password verification: FAILED (password doesn't match hash)\n";
        echo "Current hash: {$user['password']}\n";
        $newHash = password_hash($password, PASSWORD_DEFAULT);
        echo "Expected hash: $newHash\n";
        
        // Offer to update the password
        if (isset($_GET['fix_password'])) {
            $update = $pdo->prepare("UPDATE users SET password = ? WHERE id = ?");
            $update->execute([$newHash, $user['id']]);
            echo "🔧 Updated password hash in database\n";
        } else {
            echo "Add ?fix_password=1 to URL to update the password hash\n";
        }
    }
    
    // Check vendor record
    $vendorId = $user['vendor_id'] ?? 0;
    if ($vendorId) {
        $stmt = $pdo->prepare("SELECT * FROM vendors WHERE id = ?");
        $stmt->execute([$vendorId]);
    } else {
        // Try to find by email
        $stmt = $pdo->prepare("SELECT * FROM vendors WHERE contact_email = ?");
        $stmt->execute([$email]);
    }
    
    $vendor = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($vendor) {
        echo "✅ Found vendor record:\n";
        echo "- Vendor ID: {$vendor['id']}\n";
        echo "- Vendor Name: {$vendor['name']}\n";
        
        // Update user's vendor_id if needed
        if (empty($user['vendor_id'])) {
            if (isset($_GET['fix_vendor_id'])) {
                $update = $pdo->prepare("UPDATE users SET vendor_id = ? WHERE id = ?");
                $update->execute([$vendor['id'], $user['id']]);
                echo "🔧 Updated user's vendor_id to {$vendor['id']}\n";
            } else {
                echo "⚠️ User is missing vendor_id. Add ?fix_vendor_id=1 to fix\n";
            }
        }
        
    } else {
        echo "❌ No vendor record found for this user\n";
        
        // Offer to create vendor record
        if (isset($_GET['create_vendor'])) {
            $vendorName = $user['name'] . ' Vendor';
            $insert = $pdo->prepare("INSERT INTO vendors (name, contact_email, status, created_at, updated_at) VALUES (?, ?, 'Active', NOW(), NOW())");
            $insert->execute([$vendorName, $email]);
            $vendorId = $pdo->lastInsertId();
            
            // Update user's vendor_id
            $update = $pdo->prepare("UPDATE users SET vendor_id = ? WHERE id = ?");
            $update->execute([$vendorId, $user['id']]);
            
            echo "🔧 Created new vendor record with ID: $vendorId\n";
        } else {
            echo "Add ?create_vendor=1 to URL to create a vendor record\n";
        }
    }
    
    return true;
}

// Run the check
$email = 'ancientjbrx@gmail.com';
checkVendorUser($pdo, $email);

echo "\nTo fix common issues, you can use these parameters:\n";
echo "?fix_password=1 - Reset the password hash to '123456'\n";
echo "?fix_vendor_id=1 - Update user's vendor_id if missing\n";
echo "?create_vendor=1 - Create a vendor record if missing\n";

// Show all parameters for convenience
echo "\nOr use all fixes: ?fix_password=1&fix_vendor_id=1&create_vendor=1\n";
