<?php
// check_users_table.php
require __DIR__ . '/config/config.php';

try {
    // Get table structure
    $stmt = $pdo->query("DESCRIBE users");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "Users table columns:\n";
    foreach ($columns as $col) {
        echo "- {$col['Field']} ({$col['Type']})\n";
    }
    
    // Check for vendor-related columns
    $vendorCols = array_filter($columns, fn($col) => str_contains(strtolower($col['Field']), 'vendor'));
    
    if (empty($vendorCols)) {
        echo "\nNo vendor-related columns found in users table. You may need to run database migrations.\n";
    } else {
        echo "\nVendor-related columns found:\n";
        foreach ($vendorCols as $col) {
            echo "- {$col['Field']} ({$col['Type']})\n";
        }
    }
    
} catch (PDOException $e) {
    die("Error: " . $e->getMessage());
}
