<?php
require_once __DIR__ . '/config/config.php';

// Check if support_tickets table exists
$tableExists = $pdo->query("SHOW TABLES LIKE 'support_tickets'")->rowCount() > 0;

echo "Support Tickets Table Exists: " . ($tableExists ? 'Yes' : 'No') . "\n";

if ($tableExists) {
    // Get table structure
    $stmt = $pdo->query("DESCRIBE support_tickets");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "\nCurrent Columns:\n";
    foreach ($columns as $col) {
        echo "- {$col['Field']} ({$col['Type']})\n";
    }
    
    // Check if we need to add ip_address column
    $hasIpAddress = false;
    foreach ($columns as $col) {
        if ($col['Field'] === 'ip_address') {
            $hasIpAddress = true;
            break;
        }
    }
    
    if (!$hasIpAddress) {
        echo "\nAdding ip_address column...\n";
        try {
            $pdo->exec("ALTER TABLE support_tickets ADD COLUMN ip_address VARCHAR(45) DEFAULT NULL AFTER user_id");
            echo "Successfully added ip_address column\n";
        } catch (PDOException $e) {
            echo "Error adding ip_address column: " . $e->getMessage() . "\n";
        }
    } else {
        echo "\nip_address column already exists\n";
    }
    
    // Check if we need to add last_replied_at and assigned_to
    $hasLastRepliedAt = false;
    $hasAssignedTo = false;
    
    foreach ($columns as $col) {
        if ($col['Field'] === 'last_replied_at') $hasLastRepliedAt = true;
        if ($col['Field'] === 'assigned_to') $hasAssignedTo = true;
    }
    
    if (!$hasLastRepliedAt) {
        echo "\nAdding last_replied_at column...\n";
        try {
            $pdo->exec("ALTER TABLE support_tickets ADD COLUMN last_replied_at TIMESTAMP NULL DEFAULT NULL AFTER updated_at");
            echo "Successfully added last_replied_at column\n";
        } catch (PDOException $e) {
            echo "Error adding last_replied_at column: " . $e->getMessage() . "\n";
        }
    }
    
    if (!$hasAssignedTo) {
        echo "\nAdding assigned_to column...\n";
        try {
            $pdo->exec("ALTER TABLE support_tickets ADD COLUMN assigned_to INT UNSIGNED DEFAULT NULL AFTER user_id");
            $pdo->exec("ALTER TABLE support_tickets ADD CONSTRAINT fk_support_tickets_assigned_to FOREIGN KEY (assigned_to) REFERENCES agents(id) ON DELETE SET NULL");
            echo "Successfully added assigned_to column and foreign key\n";
        } catch (PDOException $e) {
            echo "Error adding assigned_to column: " . $e->getMessage() . "\n";
        }
    }
    
    echo "\nVerifying support_replies table...\n";
    $repliesTableExists = $pdo->query("SHOW TABLES LIKE 'support_replies'")->rowCount() > 0;
    
    if (!$repliesTableExists) {
        echo "Creating support_replies table...\n";
        $pdo->exec("
            CREATE TABLE IF NOT EXISTS support_replies (
                id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
                ticket_id INT UNSIGNED NOT NULL,
                user_id INT UNSIGNED DEFAULT NULL,
                agent_id INT UNSIGNED DEFAULT NULL,
                role ENUM('user', 'agent') NOT NULL,
                message TEXT NOT NULL,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                updated_at TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
                FOREIGN KEY (ticket_id) REFERENCES support_tickets(id) ON DELETE CASCADE,
                FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL,
                FOREIGN KEY (agent_id) REFERENCES agents(id) ON DELETE SET NULL
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
        ");
        echo "Created support_replies table\n";
    } else {
        // Check if agent_id column exists in support_replies
        $stmt = $pdo->query("DESCRIBE support_replies");
        $replyColumns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $hasAgentId = false;
        
        foreach ($replyColumns as $col) {
            if ($col['Field'] === 'agent_id') {
                $hasAgentId = true;
                break;
            }
        }
        
        if (!$hasAgentId) {
            echo "Adding agent_id column to support_replies...\n";
            try {
                $pdo->exec("ALTER TABLE support_replies ADD COLUMN agent_id INT UNSIGNED DEFAULT NULL AFTER user_id");
                $pdo->exec("ALTER TABLE support_replies ADD CONSTRAINT fk_support_replies_agent_id FOREIGN KEY (agent_id) REFERENCES agents(id) ON DELETE SET NULL");
                echo "Added agent_id column and foreign key to support_replies\n";
            } catch (PDOException $e) {
                echo "Error adding agent_id to support_replies: " . $e->getMessage() . "\n";
            }
        } else {
            echo "support_replies table already has agent_id column\n";
        }
    }
    
} else {
    echo "\nCreating support_tickets table...\n";
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS support_tickets (
            id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            user_id INT UNSIGNED NOT NULL,
            assigned_to INT UNSIGNED DEFAULT NULL,
            ip_address VARCHAR(45) DEFAULT NULL,
            subject VARCHAR(255) NOT NULL,
            category ENUM('general', 'billing', 'booking', 'technical', 'kyc') NOT NULL DEFAULT 'general',
            priority ENUM('low', 'normal', 'high', 'urgent') NOT NULL DEFAULT 'normal',
            message TEXT NOT NULL,
            status ENUM('open', 'pending', 'resolved', 'closed') NOT NULL DEFAULT 'open',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
            last_replied_at TIMESTAMP NULL DEFAULT NULL,
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
            FOREIGN KEY (assigned_to) REFERENCES agents(id) ON DELETE SET NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    ");
    
    echo "Created support_tickets table\n";
    
    // Create support_replies table
    echo "\nCreating support_replies table...\n";
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS support_replies (
            id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            ticket_id INT UNSIGNED NOT NULL,
            user_id INT UNSIGNED DEFAULT NULL,
            agent_id INT UNSIGNED DEFAULT NULL,
            role ENUM('user', 'agent') NOT NULL,
            message TEXT NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (ticket_id) REFERENCES support_tickets(id) ON DELETE CASCADE,
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL,
            FOREIGN KEY (agent_id) REFERENCES agents(id) ON DELETE SET NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    ");
    echo "Created support_replies table\n";
}

echo "\nSupport ticket schema verification complete!\n";
