<?php
// app/Views/agent/order_view.php
$bk = $booking ?? [];
$status = (string)($bk['status'] ?? '');
$badge = $status==='confirmed'||$status==='completed'||$status==='paid' ? 'bg-success' : ($status==='pending' ? 'bg-warning text-dark' : ($status==='cancelled' ? 'bg-danger' : 'bg-secondary'));
$created = htmlspecialchars($bk['created_at'] ?? '');
$module = htmlspecialchars($bk['module'] ?? '');
$pax = (int)($bk['pax'] ?? 0);
$total = (float)($bk['price'] ?? 0);
$agentPrice = isset($bk['agent_price']) && $bk['agent_price']!=='' ? (float)$bk['agent_price'] : null;
$vendorCost = isset($bk['vendor_cost']) && $bk['vendor_cost']!=='' ? (float)$bk['vendor_cost'] : null;
$profit = isset($bk['profit_system']) && $bk['profit_system']!=='' ? (float)$bk['profit_system'] : ($agentPrice!==null && $vendorCost!==null ? $agentPrice - $vendorCost : null);
$promoApplied = (int)($bk['promo_applied'] ?? 0) === 1;
$groupApplied = (int)($bk['group_applied'] ?? 0) === 1;

$ledgerRows = $ledger ?? [];
$sumCredit = 0.0; $sumDebit = 0.0;
foreach ($ledgerRows as $row) {
    if (($row['type'] ?? '') === 'credit') $sumCredit += (float)$row['amount'];
    if (($row['type'] ?? '') === 'debit') $sumDebit += (float)$row['amount'];
}
$paidNet = $sumCredit - $sumDebit; // perspective of wallet
$due = max(0, $total - max(0, $paidNet));
?>
<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <div class="text-muted small">Order</div>
      <h1 class="h5 mb-0">#<?php echo (int)$bk['id']; ?> · <span class="text-capitalize"><?php echo $module; ?></span></h1>
    </div>
    <div class="text-end">
      <div><span class="badge <?php echo $badge; ?> text-uppercase"><?php echo htmlspecialchars($status); ?></span></div>
      <div class="small text-muted mt-1">Created: <?php echo $created; ?></div>
    </div>
  </div>

  <div class="row g-3">
    <div class="col-12 col-lg-8">
      <div class="card shadow-sm mb-3">
        <div class="card-header bg-white"><strong>Trip Summary</strong></div>
        <div class="card-body">
          <div class="row">
            <div class="col-6 col-md-4">
              <div class="text-muted small">Module</div>
              <div class="fw-semibold text-capitalize"><?php echo $module; ?></div>
            </div>
            <div class="col-6 col-md-4">
              <div class="text-muted small">PAX</div>
              <div class="fw-semibold"><?php echo $pax; ?></div>
            </div>
            <div class="col-12 col-md-4 mt-3 mt-md-0">
              <div class="text-muted small">Order Total</div>
              <div class="h6 mb-0"><?php echo number_format($total, 2); ?> THB</div>
            </div>
          </div>
          <hr>
          <div class="row g-3">
            <div class="col-12 col-md-6">
              <div class="text-muted small mb-1">Pricing Breakdown</div>
              <ul class="list-unstyled mb-0">
                <?php if ($agentPrice !== null): ?>
                  <li class="d-flex justify-content-between"><span>Agent Price</span><span><?php echo number_format($agentPrice, 2); ?> THB</span></li>
                <?php endif; ?>
                <?php if ($vendorCost !== null): ?>
                  <li class="d-flex justify-content-between"><span>Vendor Cost</span><span><?php echo number_format($vendorCost, 2); ?> THB</span></li>
                <?php endif; ?>
                <?php if ($profit !== null): ?>
                  <li class="d-flex justify-content-between"><span>Profit</span><span class="text-success">+<?php echo number_format($profit, 2); ?> THB</span></li>
                <?php endif; ?>
                <?php if ($promoApplied): ?>
                  <li class="d-flex justify-content-between"><span>Promo</span><span class="text-primary">Applied</span></li>
                <?php endif; ?>
                <?php if ($groupApplied): ?>
                  <li class="d-flex justify-content-between"><span>Group Pricing</span><span class="text-primary">Applied</span></li>
                <?php endif; ?>
              </ul>
            </div>
            <div class="col-12 col-md-6">
              <div class="text-muted small mb-1">Order Status</div>
              <div class="d-flex align-items-center gap-2 flex-wrap">
                <span class="badge <?php echo $badge; ?> text-uppercase"><?php echo htmlspecialchars($status); ?></span>
                <?php if ($due <= 0): ?>
                  <span class="badge bg-success">Paid</span>
                <?php else: ?>
                  <span class="badge bg-warning text-dark">Payment Due</span>
                <?php endif; ?>
              </div>
              <div class="small text-muted mt-2">Order placed on <?php echo $created; ?></div>
            </div>
          </div>
        </div>
      </div>

      <div class="card shadow-sm">
        <div class="card-header bg-white d-flex justify-content-between align-items-center">
          <strong>Payment & Ledger</strong>
          <div class="small text-muted">Wallet Balance: <?php echo number_format((float)($balance ?? 0), 2); ?> THB</div>
        </div>
        <div class="card-body">
          <div class="row mb-3">
            <div class="col-6 col-md-4">
              <div class="text-muted small">Total Paid (net)</div>
              <div class="fw-semibold"><?php echo number_format($paidNet, 2); ?> THB</div>
            </div>
            <div class="col-6 col-md-4">
              <div class="text-muted small">Amount Due</div>
              <div class="fw-semibold <?php echo $due>0?'text-danger':''; ?>"><?php echo number_format($due, 2); ?> THB</div>
            </div>
          </div>

          <div class="table-responsive">
            <table class="table align-middle mb-0">
              <thead>
                <tr>
                  <th>#</th>
                  <th>Type</th>
                  <th>Amount</th>
                  <th>Method</th>
                  <th>Status</th>
                  <th>Time</th>
                </tr>
              </thead>
              <tbody>
              <?php if (!empty($ledgerRows)): foreach ($ledgerRows as $l): ?>
                <?php
                  $t = (string)$l['type'];
                  $b = $t==='credit' ? 'bg-success' : ($t==='debit' ? 'bg-danger' : 'bg-secondary');
                  $st = (string)$l['status'];
                  $sb = $st==='approved' ? 'bg-success' : ($st==='pending' ? 'bg-warning text-dark' : 'bg-secondary');
                ?>
                <tr>
                  <td><?php echo (int)$l['id']; ?></td>
                  <td><span class="badge <?php echo $b; ?> text-uppercase"><?php echo htmlspecialchars($t); ?></span></td>
                  <td><strong><?php echo number_format((float)$l['amount'], 2); ?></strong> THB</td>
                  <td class="text-capitalize"><?php echo htmlspecialchars($l['method']); ?></td>
                  <td><span class="badge <?php echo $sb; ?> text-uppercase"><?php echo htmlspecialchars($st); ?></span></td>
                  <td class="text-nowrap">&nbsp;<?php echo htmlspecialchars($l['created_at'] ?? ''); ?></td>
                </tr>
              <?php endforeach; else: ?>
                <tr>
                  <td colspan="6" class="text-center text-muted py-4">No related wallet transactions found.</td>
                </tr>
              <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

    <div class="col-12 col-lg-4">
      <div class="card shadow-sm mb-3">
        <div class="card-header bg-white"><strong>Actions</strong></div>
        <div class="list-group list-group-flush">
          <a class="list-group-item list-group-item-action" href="#">Download Invoice (PDF)</a>
          <a class="list-group-item list-group-item-action" href="#">Request Changes</a>
          <a class="list-group-item list-group-item-action" href="/agent/support">Contact Support</a>
        </div>
      </div>

      <div class="card shadow-sm">
        <div class="card-header bg-white"><strong>Need Help?</strong></div>
        <div class="card-body">
          <div class="small text-muted mb-1">Support Hotline</div>
          <div class="fw-semibold">+66-2-123-4567</div>
          <div class="small text-muted mt-3 mb-1">Email</div>
          <div class="fw-semibold">support@b3bthaihub.com</div>
        </div>
      </div>
    </div>
  </div>
</div>
