<?php
// Agent Header (Tailwind tw- prefix, no Bootstrap)
?>
<header class="tw-sticky tw-top-0 tw-z-40 tw-bg-[#1B4F9C] tw-text-white tw-shadow-sm">
  <div class="tw-max-w-7xl tw-mx-auto tw-px-4 tw-h-14 tw-flex tw-items-center tw-justify-between">
    <a href="/agent" class="tw-flex tw-items-center tw-gap-2 tw-font-extrabold">
      <span class="tw-w-7 tw-h-7 tw-rounded-full tw-bg-white/15 tw-grid tw-place-items-center">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="tw-w-4 tw-h-4">
          <path fill-rule="evenodd" d="M2.5 4.75a.75.75 0 0 1 .917-.73l17 4a.75.75 0 0 1 .093 1.425l-7.236 3.014a1.5 1.5 0 0 0-.756.642l-2.27 3.784c-.45.75-1.59.57-1.752-.28l-.62-3.314a1.5 1.5 0 0 0-1.058-1.17L3.01 10.98A.75.75 0 0 1 3.1 9.53l15.1-2.94-13.9-3.27A.75.75 0 0 1 2.5 4.75Z" clip-rule="evenodd" />
        </svg>
      </span>
      <span>B2BTHAIHUB.COM</span>
    </a>

    <nav class="tw-hidden md:tw-flex tw-items-center tw-gap-6">
      <a class="tw-text-white/90 hover:tw-text-white tw-text-sm" href="/agent">Home</a>
      <a class="tw-text-white/90 hover:tw-text-white tw-text-sm" href="/agent/hotels">Hotels</a>
      <a class="tw-text-white/90 hover:tw-text-white tw-text-sm" href="/agent/cars">Cars</a>
      <a class="tw-text-white/90 hover:tw-text-white tw-text-sm" href="/agent/yachts">Yachts</a>
      <a class="tw-text-white/90 hover:tw-text-white tw-text-sm" href="/agent/activities">Activities</a>
      <a class="tw-text-white/90 hover:tw-text-white tw-text-sm" href="/agent/packages">Packages</a>
    </nav>

    <div class="tw-hidden sm:tw-flex tw-items-center tw-gap-2">
      <a class="tw-inline-flex tw-items-center tw-h-9 tw-rounded-xl tw-px-3 tw-border tw-border-white/25 hover:tw-border-white tw-bg-white/5 tw-text-white tw-text-sm" href="/partner/signup">Become a Partner</a>
      <?php if (!empty($_SESSION['user'])): ?>
        <a class="tw-inline-flex tw-items-center tw-h-9 tw-rounded-xl tw-px-3 tw-border tw-border-white/25 hover:tw-border-white tw-text-white tw-text-sm" href="/logout">Sign out</a>
      <?php else: ?>
        <a class="tw-inline-flex tw-items-center tw-h-9 tw-rounded-xl tw-px-3 tw-border tw-border-white/25 hover:tw-border-white tw-text-white tw-text-sm" href="/login/agent">Sign In / Register</a>
      <?php endif; ?>
    </div>

    <button id="openMobileMenu" aria-label="Open menu" class="md:tw-hidden tw-inline-flex tw-items-center tw-justify-center tw-w-10 tw-h-10 tw-rounded-lg tw-text-white hover:tw-bg-white/10 focus:tw-outline-none focus:tw-ring-2 focus:tw-ring-white/50">
      <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="tw-w-6 tw-h-6"><path fill-rule="evenodd" d="M3.75 6.75A.75.75 0 014.5 6h15a.75.75 0 010 1.5h-15a.75.75 0 01-.75-.75zm0 5.25a.75.75 0 01.75-.75h15a.75.75 0 010 1.5h-15a.75.75 0 01-.75-.75zm.75 4.5a.75.75 0 000 1.5h15a.75.75 0 000-1.5h-15z" clip-rule="evenodd"/></svg>
    </button>
  </div>

  <!-- Mobile slide-in menu -->
  <div id="mobileMenu" class="tw-fixed tw-inset-0 tw-z-50 tw-hidden" aria-hidden="true">
    <div id="mobileBackdrop" class="tw-absolute tw-inset-0 tw-bg-black/40 tw-opacity-0 tw-transition-opacity"></div>
    <aside id="mobilePanel" class="tw-absolute tw-right-0 tw-top-0 tw-h-full tw-w-72 tw-max-w-[85vw] tw-bg-white tw-text-slate-900 tw-shadow-xl tw-translate-x-full tw-transition-transform">
      <div class="tw-h-14 tw-px-4 tw-flex tw-items-center tw-justify-between tw-border-b">
        <span class="tw-font-extrabold tw-text-[#1B4F9C]">B2BTHAIHUB.COM</span>
        <button id="closeMobileMenu" aria-label="Close menu" class="tw-inline-flex tw-items-center tw-justify-center tw-w-9 tw-h-9 tw-rounded-lg hover:tw-bg-slate-100">
          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="tw-w-6 tw-h-6"><path fill-rule="evenodd" d="M6.72 6.72a.75.75 0 011.06 0L12 10.94l4.22-4.22a.75.75 0 111.06 1.06L13.06 12l4.22 4.22a.75.75 0 11-1.06 1.06L12 13.06l-4.22 4.22a.75.75 0 11-1.06-1.06L10.94 12 6.72 7.78a.75.75 0 010-1.06z" clip-rule="evenodd"/></svg>
        </button>
      </div>
      <nav class="tw-px-4 tw-py-3 tw-grid tw-gap-2">
        <a class="tw-py-2" href="/agent">Home</a>
        <a class="tw-py-2" href="/agent/hotels">Hotels</a>
        <a class="tw-py-2" href="/agent/cars">Cars</a>
        <a class="tw-py-2" href="/agent/yachts">Yachts</a>
        <a class="tw-py-2" href="/agent/activities">Activities</a>
        <a class="tw-py-2" href="/agent/packages">Packages</a>
        <div class="tw-h-px tw-bg-slate-200 tw-my-2"></div>
        <a class="tw-inline-flex tw-items-center tw-justify-center tw-h-10 tw-rounded-xl tw-border tw-border-slate-300 hover:tw-bg-slate-50" href="/partner/signup">Become a Partner</a>
        <?php if (!empty($_SESSION['user'])): ?>
          <a class="tw-inline-flex tw-items-center tw-justify-center tw-h-10 tw-rounded-xl tw-bg-[#1B4F9C] tw-text-white" href="/logout">Sign out</a>
        <?php else: ?>
          <a class="tw-inline-flex tw-items-center tw-justify-center tw-h-10 tw-rounded-xl tw-bg-[#1B4F9C] tw-text-white" href="/login/agent">Sign In / Register</a>
        <?php endif; ?>
      </nav>
    </aside>
  </div>
</header>
<script>
  (function(){
    const openBtn = document.getElementById('openMobileMenu');
    const closeBtn = document.getElementById('closeMobileMenu');
    const menu = document.getElementById('mobileMenu');
    const backdrop = document.getElementById('mobileBackdrop');
    const panel = document.getElementById('mobilePanel');
    if (!openBtn || !menu) return;
    const open = () => {
      menu.classList.remove('tw-hidden');
      requestAnimationFrame(() => {
        backdrop.classList.remove('tw-opacity-0');
        panel.classList.remove('tw-translate-x-full');
        document.body.style.overflow = 'hidden';
      });
    };
    const close = () => {
      backdrop.classList.add('tw-opacity-0');
      panel.classList.add('tw-translate-x-full');
      document.body.style.overflow = '';
      setTimeout(() => menu.classList.add('tw-hidden'), 200);
    };
    openBtn.addEventListener('click', open);
    closeBtn && closeBtn.addEventListener('click', close);
    backdrop && backdrop.addEventListener('click', close);
    document.addEventListener('keydown', (e) => { if(e.key==='Escape') close(); });
  })();
</script>
