<?php
// Agent Footer (Tailwind tw- prefix)
?>
<footer class="tw-bg-slate-50 tw-border-t tw-border-slate-200">
  <div class="tw-max-w-7xl tw-mx-auto tw-px-4 tw-py-10">
    <div class="tw-grid tw-gap-8 md:tw-grid-cols-12">
      <div class="md:tw-col-span-4">
        <div class="tw-flex tw-items-center tw-gap-2 tw-font-extrabold tw-text-[#1B4F9C]">
          <span class="tw-w-8 tw-h-8 tw-rounded-full tw-bg-[#1B4F9C]/10 tw-grid tw-place-items-center">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="tw-w-4 tw-h-4">
              <path fill-rule="evenodd" d="M2.5 4.75a.75.75 0 0 1 .917-.73l17 4a.75.75 0 0 1 .093 1.425l-7.236 3.014a1.5 1.5 0 0 0-.756.642l-2.27 3.784c-.45.75-1.59.57-1.752-.28l-.62-3.314a1.5 1.5 0 0 0-1.058-1.17L3.01 10.98A.75.75 0 0 1 3.1 9.53l15.1-2.94-13.9-3.27A.75.75 0 0 1 2.5 4.75Z" clip-rule="evenodd" />
            </svg>
          </span>
          B2BTHAIHUB.COM
        </div>
        <p class="tw-mt-3 tw-text-sm tw-text-slate-600 tw-max-w-md">Plan, book and manage with a single portal. Hotels, activities, cars, yachts and packages with instant confirmation and agent wallet support.</p>
      </div>

      <div class="md:tw-col-span-2">
        <h3 class="tw-font-semibold tw-text-slate-900">Products</h3>
        <ul class="tw-mt-3 tw-space-y-2 tw-text-sm tw-text-slate-600">
          <li><a class="hover:tw-text-[#1B4F9C]" href="/agent/hotels">Hotels</a></li>
          <li><a class="hover:tw-text-[#1B4F9C]" href="/agent/activities">Activities</a></li>
          <li><a class="hover:tw-text-[#1B4F9C]" href="/agent/cars">Cars</a></li>
          <li><a class="hover:tw-text-[#1B4F9C]" href="/agent/yachts">Yachts</a></li>
          <li><a class="hover:tw-text-[#1B4F9C]" href="/agent/packages">Packages</a></li>
        </ul>
      </div>

      <div class="md:tw-col-span-2">
        <h3 class="tw-font-semibold tw-text-slate-900">Company</h3>
        <ul class="tw-mt-3 tw-space-y-2 tw-text-sm tw-text-slate-600">
          <li><a class="hover:tw-text-[#1B4F9C]" href="#">About us</a></li>
          <li><a class="hover:tw-text-[#1B4F9C]" href="#">Partners</a></li>
          <li><a class="hover:tw-text-[#1B4F9C]" href="#">Careers</a></li>
          <li><a class="hover:tw-text-[#1B4F9C]" href="#">Contact</a></li>
        </ul>
      </div>

      <div class="md:tw-col-span-2">
        <h3 class="tw-font-semibold tw-text-slate-900">Support</h3>
        <ul class="tw-mt-3 tw-space-y-2 tw-text-sm tw-text-slate-600">
          <li><a class="hover:tw-text-[#1B4F9C]" href="#">Help center</a></li>
          <li><a class="hover:tw-text-[#1B4F9C]" href="#">Cancellations</a></li>
          <li><a class="hover:tw-text-[#1B4F9C]" href="#">Payments</a></li>
          <li><a class="hover:tw-text-[#1B4F9C]" href="#">Agent wallet</a></li>
        </ul>
      </div>

      <div class="md:tw-col-span-2">
        <h3 class="tw-font-semibold tw-text-slate-900">Stay in the loop</h3>
        <p class="tw-mt-3 tw-text-sm tw-text-slate-600">Subscribe for deals and new features.</p>
        <form class="tw-mt-3 tw-flex tw-gap-2" onsubmit="event.preventDefault(); alert('Subscribed!');">
          <input type="email" required placeholder="you@example.com" class="tw-w-full tw-h-10 tw-rounded-xl tw-border tw-border-slate-300 focus:tw-ring-2 focus:tw-ring-[#1B4F9C] focus:tw-outline-none tw-px-3" />
          <button class="tw-inline-flex tw-items-center tw-justify-center tw-h-10 tw-rounded-xl tw-bg-[#1B4F9C] tw-text-white tw-px-4">Subscribe</button>
        </form>
      </div>
    </div>

    <div class="tw-mt-10 tw-pt-6 tw-border-t tw-border-slate-200 tw-flex tw-flex-col tw-gap-3 sm:tw-flex-row tw-items-center tw-justify-between tw-text-sm tw-text-slate-500">
      <p>© <?= date('Y') ?> B2BTHAIHUB.COM. All rights reserved.</p>
      <div class="tw-flex tw-items-center tw-gap-4">
        <a class="hover:tw-text-[#1B4F9C]" href="#">Privacy</a>
        <span class="tw-text-slate-300">|</span>
        <a class="hover:tw-text-[#1B4F9C]" href="#">Terms</a>
        <span class="tw-text-slate-300">|</span>
        <a class="hover:tw-text-[#1B4F9C]" href="#">Cookies</a>
      </div>
    </div>
  </div>
</footer>
