<div class="tw-min-h-[60vh] tw-flex tw-items-center tw-justify-center tw-py-12">
  <div class="tw-w-full tw-max-w-md tw-bg-white tw-rounded-2xl tw-shadow-lg tw-p-8">
    <div class="tw-flex tw-items-center tw-justify-between tw-mb-6">
      <h1 class="tw-text-2xl tw-font-bold tw-text-gray-900">B2B Login</h1>
      <a href="/login/select" class="tw-text-sm tw-font-medium tw-text-blue-600 hover:tw-text-blue-700">Change Role</a>
    </div>
    <?php if (!empty($_SESSION['flash'])): ?>
      <div class="tw-mb-4 tw-rounded-lg tw-border tw-border-amber-300 tw-bg-amber-50 tw-text-amber-900 tw-text-sm tw-px-3 tw-py-2">
        <?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?>
      </div>
    <?php endif; ?>
    <form method="post" action="/login/agent" class="tw-space-y-4">
      <input type="hidden" name="csrf" value="<?= \App\Core\Security::csrfToken(); ?>">
      <div>
        <label class="tw-block tw-text-sm tw-font-medium tw-text-gray-700">Email</label>
        <input type="email" name="email" required autocomplete="username" autofocus
               class="tw-mt-1 tw-block tw-w-full tw-rounded-lg tw-border tw-border-gray-300 tw-bg-white tw-px-3 tw-py-2 tw-text-gray-900 placeholder:tw-text-gray-400 focus:tw-outline-none focus:tw-ring-2 focus:tw-ring-blue-500 focus:tw-border-blue-500" />
      </div>
      <div>
        <label class="tw-block tw-text-sm tw-font-medium tw-text-gray-700">Password</label>
        <input type="password" name="password" required autocomplete="current-password"
               class="tw-mt-1 tw-block tw-w-full tw-rounded-lg tw-border tw-border-gray-300 tw-bg-white tw-px-3 tw-py-2 tw-text-gray-900 placeholder:tw-text-gray-400 focus:tw-outline-none focus:tw-ring-2 focus:tw-ring-blue-500 focus:tw-border-blue-500" />
      </div>
      <button type="submit"
              class="tw-w-full tw-inline-flex tw-justify-center tw-items-center tw-rounded-lg tw-bg-blue-600 hover:tw-bg-blue-700 tw-text-white tw-font-semibold tw-py-2.5 tw-shadow-sm">
        Login as B2B
      </button>
    </form>
  </div>
</div>
