<?php
/** @var int $id @var string $checkin @var string $checkout */
$hotelId = (int)($id ?? 0);
$checkin = $checkin ?? '';
$checkout = $checkout ?? '';
$title = $title ?? 'Hotel Details';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title) ?></title>
  <link rel="stylesheet" href="/public/assets/css/agent.css">
  <style>
    .wrap{max-width:1100px;margin:20px auto;padding:0 12px}
    .card{background:#fff;border:1px solid #e5e7eb;border-radius:12px;box-shadow:0 1px 2px rgba(0,0,0,.04)}
    .p-16{padding:16px}
    .grid{display:grid;gap:16px}
    .grid-2{grid-template-columns: 1fr;}
    @media(min-width:980px){ .grid-2{grid-template-columns: 2fr 1fr;} }
    .room{display:flex;gap:12px;border:1px solid #e5e7eb;border-radius:10px;padding:12px;align-items:flex-start}
    .room img{width:120px;height:90px;object-fit:cover;border-radius:8px;background:#f3f4f6}
    .meta{font-size:.9rem;color:#475569}
    .price{margin-left:auto;text-align:right}
    .btn{background:#2563eb;color:#fff;border:none;padding:10px 14px;border-radius:8px;cursor:pointer}
    .btn:disabled{opacity:.6;cursor:not-allowed}
    .field{display:flex;flex-direction:column;gap:6px}
    .field input,.field select{padding:10px 12px;border:1px solid #d1d5db;border-radius:8px}
  </style>
</head>
<body>
  <div class="wrap">
    <div class="p-16" style="padding-top:0">
      <a href="/agent/hotels" style="color:#1B4F9C">← Back to hotels</a>
    </div>
    <div class="grid grid-2">
      <main>
        <div class="card p-16">
          <h1 id="hTitle" style="margin:0 0 6px;font-size:22px;font-weight:800">Loading…</h1>
          <div id="hSub" class="meta"></div>
          <div id="hGallery" style="margin-top:12px;height:280px;background:#f8fafc;border-radius:12px"></div>
          <h2 style="margin-top:16px">Rooms</h2>
          <div id="rooms"></div>
        </div>
      </main>
      <aside>
        <div class="card p-16">
          <h3 style="margin-top:0">Book this hotel</h3>
          <form id="bookForm" method="post" action="/agent/booking/create/hotel">
            <input type="hidden" name="csrf_token" value="<?= htmlspecialchars(App\Core\Security::csrfToken()) ?>">
            <input type="hidden" name="hotel_id" value="<?= (int)$hotelId ?>">
            <input type="hidden" name="room_id" id="f_room_id">
            <div class="field">
              <label>Check-in</label>
              <input type="date" name="check_in_date" id="f_checkin" value="<?= htmlspecialchars($checkin) ?>" required>
            </div>
            <div class="field">
              <label>Check-out</label>
              <input type="date" name="check_out_date" id="f_checkout" value="<?= htmlspecialchars($checkout) ?>" required>
            </div>
            <div class="field">
              <label>Rooms</label>
              <select name="rooms" id="f_rooms">
                <?php for($i=1;$i<=6;$i++): ?>
                  <option value="<?= $i ?>"><?= $i ?></option>
                <?php endfor; ?>
              </select>
            </div>
            <div class="field">
              <label>Adults</label>
              <select name="adults" id="f_adults">
                <?php for($i=1;$i<=6;$i++): ?>
                  <option value="<?= $i ?>"><?= $i ?></option>
                <?php endfor; ?>
              </select>
            </div>
            <div class="field">
              <label>Children</label>
              <select name="children" id="f_children">
                <?php for($i=0;$i<=4;$i++): ?>
                  <option value="<?= $i ?>"><?= $i ?></option>
                <?php endfor; ?>
              </select>
            </div>
            <button type="submit" class="btn" style="margin-top:10px;width:100%">Create booking</button>
            <div id="fHint" class="meta" style="margin-top:6px"></div>
          </form>
        </div>
      </aside>
    </div>
  </div>

  <script>
  (function(){
    const HID = <?= json_encode((int)$hotelId) ?>;
    const CHECKIN = <?= json_encode($checkin) ?>;
    const CHECKOUT = <?= json_encode($checkout) ?>;
    const $title = document.getElementById('hTitle');
    const $sub = document.getElementById('hSub');
    const $rooms = document.getElementById('rooms');
    const $fRoom = document.getElementById('f_room_id');
    const $hint = document.getElementById('fHint');

    function esc(s){ return (s||'').toString().replace(/[&<>]/g, ch=>({"&":"&amp;","<":"&lt;",">":"&gt;"}[ch])); }
    function fmt(n){ return new Intl.NumberFormat('en-US',{maximumFractionDigits:0}).format(n||0); }

    function pickRoom(id, label){
      $fRoom.value = id||'';
      $hint.textContent = id? ('Selected room: '+label) : '';
    }

    function renderRooms(list, nightlyBase){
      $rooms.innerHTML = '';
      if(!list || !list.length){ $rooms.innerHTML = '<div class="meta">No rooms available.</div>'; return; }
      list.forEach(r=>{
        const price = (r.nightly_from_agent != null ? r.nightly_from_agent : nightlyBase)||0;
        const cap = r.capacity != null ? r.capacity : '';
        const el = document.createElement('div');
        el.className = 'room';
        el.innerHTML = `
          <img src="/public/assets/img/hotel_room_placeholder.jpg" alt="Room" onerror="this.src='/public/assets/img/hotel_room_placeholder.jpg'" />
          <div>
            <div style="font-weight:600">${esc(r.name||'Room')}</div>
            <div class="meta">Capacity: ${cap||'N/A'} guests</div>
            <div class="meta">Agent price from: <b>THB ${fmt(price)}</b> / night</div>
          </div>
          <div class="price">
            <button class="btn" type="button">Select Room</button>
          </div>`;
        el.querySelector('button').addEventListener('click', ()=> pickRoom(r.id, r.name||'Room'));
        $rooms.appendChild(el);
      });
    }

    async function load(){
      try{
        const params = new URLSearchParams({ id: String(HID) });
        if(CHECKIN) params.set('checkin', CHECKIN);
        if(CHECKOUT) params.set('checkout', CHECKOUT);
        const res = await fetch(`/b2b/api/hotels/details?${params.toString()}`, { credentials:'same-origin' });
        if(!res.ok) throw new Error('Failed to load hotel');
        const js = await res.json();
        const h = js.hotel || {};
        $title.textContent = h.name || 'Hotel';
        $sub.textContent = [h.city, h.country, (h.stars? ('★'.repeat(h.stars)):'')].filter(Boolean).join(' • ');
        renderRooms(js.rooms||[], (h.base_price||0));
      }catch(e){
        $title.textContent = 'Hotel unavailable';
        $rooms.innerHTML = '<div class="meta">'+esc(e.message||'Error')+'</div>';
      }
    }

    load();
  })();
  </script>
</body>
</html>
