<?php
// app/Views/agent/activities_list.php
// Dedicated Activities List page for B2B Agent
$q = isset($q) ? (string)$q : (string)($_GET['q'] ?? '');
$city = isset($city) ? (string)$city : (string)($_GET['city'] ?? '');
?>
<div class="activities-page-bg">
<div class="tw-max-w-screen-xl tw-mx-auto tw-px-4 tw-pt-3 tw-pb-2">
  <div class="tw-flex tw-items-center tw-justify-between tw-mb-2">
    <h1 class="tw-text-lg tw-font-semibold tw-m-0">Activities</h1>
    <a href="/agent" class="tw-inline-flex tw-items-center tw-gap-1 tw-rounded-lg tw-border tw-border-slate-300 tw-text-slate-700 hover:tw-bg-slate-50 tw-px-3 tw-py-1 tw-text-sm">
      <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="tw-w-4 tw-h-4"><path fill-rule="evenodd" d="M10.03 3.97a.75.75 0 010 1.06L5.81 9.25H21a.75.75 0 010 1.5H5.81l4.22 4.22a.75.75 0 11-1.06 1.06l-5.5-5.5a.75.75 0 010-1.06l5.5-5.5a.75.75 0 011.06 0z" clip-rule="evenodd"/></svg>
      Back
    </a>
  </div>
</div>

  <div class="tw-rounded-2xl tw-bg-white tw-shadow-md tw-ring-1 tw-ring-slate-100 tw-mb-4">
    <div class="tw-p-4">
      <form class="tw-grid tw-grid-cols-12 tw-gap-3 tw-items-end" id="activitiesListSearch">
        <div class="tw-col-span-12 lg:tw-col-span-6">
          <label class="tw-text-xs tw-font-medium tw-text-slate-600">Activity / City</label>
          <div class="tw-relative">
            <span class="tw-absolute tw-right-4 tw-top-1/2 tw--translate-y-1/2 tw-text-slate-400">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="tw-w-4 tw-h-4"><path fill-rule="evenodd" d="M10.5 3.75a6.75 6.75 0 104.243 12.03l3.238 3.239a.75.75 0 101.06-1.061l-3.238-3.238A6.75 6.75 0 0010.5 3.75zm0 1.5a5.25 5.25 0 110 10.5 5.25 5.25 0 010-10.5z" clip-rule="evenodd"/></svg>
            </span>
            <input type="text" id="q" name="q" value="<?= htmlspecialchars($q ?: ($city? ($q?"$q, $city":$city) : '')) ?>" placeholder="Alcazar Show, Pattaya" class="tw-w-full tw-h-12 tw-border tw-border-slate-200 tw-rounded-full tw-pl-4 tw-pr-11 focus:tw-outline-none focus:tw-ring-2 focus:tw-ring-blue-600/20 focus:tw-border-blue-600">
          </div>
          <input type="hidden" id="city" name="city" value="<?= htmlspecialchars($city) ?>">
        </div>
        <div class="tw-col-span-6 lg:tw-col-span-2">
          <label class="tw-text-xs tw-font-medium tw-text-slate-600">Date</label>
          <input type="date" id="date" placeholder="dd/mm/yyyy" class="tw-w-full tw-h-12 tw-rounded-full tw-border tw-border-slate-200 tw-px-4 focus:tw-ring-2 focus:tw-ring-blue-600/20 focus:tw-outline-none">
        </div>
        <div class="tw-col-span-6 lg:tw-col-span-2">
          <label class="tw-text-xs tw-font-medium tw-text-slate-600">Pax</label>
          <select id="pax" class="tw-w-full tw-h-12 tw-rounded-full tw-border tw-border-slate-200 tw-px-4 focus:tw-ring-2 focus:tw-ring-blue-600/20 focus:tw-outline-none">
            <option>2</option>
            <option>4</option>
            <option>6</option>
          </select>
        </div>
        <div class="tw-col-span-12 lg:tw-col-span-2">
          <button class="tw-inline-flex tw-items-center tw-justify-center tw-gap-2 tw-w-full tw-h-12 tw-rounded-full tw-bg-blue-900 hover:tw-bg-blue-800 tw-text-white tw-font-semibold tw-px-4 tw-shadow-sm" type="submit">
            Search
          </button>
        </div>
      </form>
    </div>
  </div>

  <div class="tw-grid tw-grid-cols-1 lg:tw-grid-cols-12 tw-gap-3">
    <div class="lg:tw-col-span-3">
      <div class="tw-sticky tw-top-3 tw-rounded-2xl tw-bg-white tw-shadow-md tw-ring-1 tw-ring-slate-100">
        <div class="tw-p-4 tw-border-b tw-border-slate-200/70">
          <div class="tw-mb-2 md:tw-hidden">
            <button id="mobileShowFiltersActivities" class="tw-w-full tw-inline-flex tw-items-center tw-justify-center tw-rounded-xl tw-border tw-border-slate-300 hover:tw-bg-slate-50 tw-py-2">Filters</button>
          </div>
          <div class="tw-flex tw-items-center tw-justify-between">
            <div class="tw-font-semibold">Filters</div>
            <button id="filtersToggleBtn" class="tw-inline-flex tw-items-center tw-gap-1 tw-text-sm tw-text-blue-700 hover:tw-text-blue-800" type="button">
              <span class="tw-hidden md:tw-inline">Show</span>
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="tw-w-4 tw-h-4"><path fill-rule="evenodd" d="M12 15.75a.75.75 0 01-.53-.22l-6-6a.75.75 0 111.06-1.06L12 13.94l5.47-5.47a.75.75 0 111.06 1.06l-6 6a.75.75 0 01-.53.22z" clip-rule="evenodd"/></svg>
            </button>
          </div>
          <div id="filtersSummary" class="tw-mt-2 tw-flex tw-flex-wrap tw-gap-1 md:tw-hidden">
            <span class="tw-text-xs tw-text-slate-500">No filters applied</span>
          </div>
        </div>
        <div id="filtersContent" class="tw-p-4 tw-space-y-4">
          

          <div class="tw-border-t tw-pt-4">
            <div class="tw-flex tw-items-center tw-justify-between">
              <div class="tw-text-xs tw-font-medium tw-text-slate-600 tw-mb-1">Cities</div>
              <a href="#" id="clearCity" class="tw-text-xs tw-text-blue-700">Clear</a>
            </div>
            <div id="cityList" class="tw-mt-2 tw-grid tw-grid-cols-2 tw-gap-2 tw-max-h-64 tw-overflow-auto"></div>
          </div>

          
        </div>
        <div class="tw-sticky tw-bottom-0 tw-bg-white tw-p-4 tw-border-t tw-border-slate-200/70">
          <div class="tw-flex tw-items-center tw-justify-between tw-gap-2">
            <button id="btnClearFilters" class="tw-text-sm tw-text-blue-700 hover:tw-text-blue-800" type="button">Clear all</button>
            <button id="btnApplyFilters" class="tw-inline-flex tw-items-center tw-justify-center tw-rounded-full tw-border tw-border-blue-900 tw-text-blue-900 hover:tw-bg-blue-50 tw-py-2 tw-px-4 tw-font-semibold tw-shadow-sm" type="button">Apply filters</button>
          </div>
        </div>
      </div>
    </div>

    <div class="lg:tw-col-span-9">
      <div class="tw-flex tw-items-center tw-justify-between tw-mb-2">
        <div id="resultsMeta" class="tw-text-sm tw-text-slate-500"></div>
        <div id="pagerTop" class="tw-text-sm"></div>
      </div>
      <div id="resultsList" class="tw-space-y-3"></div>
      <div class="tw-flex tw-items-center tw-justify-between tw-mt-2">
        <div></div>
        <nav id="pagerBottom"></nav>
      </div>
    </div>
  </div>
</div>

<!-- Loading overlay -->
<div id="loadingOverlay" class="tw-fixed tw-inset-0 tw-bg-white/70 tw-backdrop-blur-sm tw-z-40" aria-live="polite" aria-busy="true">
  <div class="tw-absolute tw-inset-0 tw-flex tw-items-center tw-justify-center">
    <div class="tw-flex tw-flex-col tw-items-center tw-gap-3 tw-text-slate-700">
      <svg class="tw-animate-spin tw-h-8 tw-w-8 tw-text-blue-900" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" aria-hidden="true">
        <circle class="tw-opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
        <path class="tw-opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"></path>
      </svg>
      <div class="tw-text-sm tw-font-medium">Fetching activities…</div>
    </div>
  </div>
  <span class="tw-sr-only">Loading</span>
  </div>

<script>
(function(){
  // Apply page background (whitesmoke) while on this page, with strong override
  try {
    document.documentElement.classList.add('bg-booking');
    document.body.classList.add('bg-booking');
    document.body.classList.add('page-activities');
    document.documentElement.style.backgroundColor = 'whitesmoke';
    document.body.style.backgroundColor = 'whitesmoke';
  } catch(e) {}
  window.addEventListener('beforeunload', function(){
    try {
      document.documentElement.classList.remove('bg-booking');
      document.body.classList.remove('bg-booking');
      document.body.classList.remove('page-activities');
      document.documentElement.style.backgroundColor = '';
      document.body.style.backgroundColor = '';
    } catch(e) {}
  });

  const form = document.getElementById('activitiesListSearch');
  const inputQ = document.getElementById('q');
  const inputCity = document.getElementById('city');
  const selectSort = document.createElement('div'); // sort hidden in this design
  const meta = document.getElementById('resultsMeta');
  const list = document.getElementById('resultsList');
  const minPrice = document.getElementById('minPrice'); // optional (may not exist)
  const maxPrice = document.getElementById('maxPrice'); // optional (may not exist)
  const btnApplyFilters = document.getElementById('btnApplyFilters');
  const btnClearFilters = document.getElementById('btnClearFilters');
  const pagerTop = document.getElementById('pagerTop');
  const pagerBottom = document.getElementById('pagerBottom');
  const filtersToggleBtn = document.getElementById('filtersToggleBtn');
  const filtersContent = document.getElementById('filtersContent');
  const filtersSummary = document.getElementById('filtersSummary');
  const mobileFiltersBtn = document.getElementById('mobileShowFiltersActivities');
  const cityList = document.getElementById('cityList');
  const clearCity = document.getElementById('clearCity');

  let allItems = [];
  let view = 'list';
  let page = 1;
  const pageSize = 20;

  function skeleton() {
    return `
      <div class="tw-animate-pulse tw-space-y-2 tw-mb-2">
        <div class="tw-h-4 tw-w-1/2 tw-bg-slate-200 tw-rounded"></div>
        <div class="tw-h-3 tw-w-3/4 tw-bg-slate-200 tw-rounded"></div>
        <div class="tw-h-3 tw-w-1/4 tw-bg-slate-200 tw-rounded"></div>
      </div>`;
  }

  // Clear City link
  if (clearCity){
    clearCity.addEventListener('click', function(ev){
      ev.preventDefault();
      inputCity.value = '';
      if (inputQ) inputQ.value = '';
      search();
    });
  }

  async function loadCities(){
    if (!cityList) return;
    try{
      const res = await fetch('/b2b/api/activities/cities?country=Thailand', { headers: { 'Accept':'application/json' } });
      const js = await res.json();
      const arr = Array.isArray(js.data) ? js.data : [];
      cityList.innerHTML = arr.map(r=>`<button type="button" data-city="${r.city}" class="tw-text-sm tw-px-3 tw-py-1 tw-rounded-full tw-border tw-border-slate-200 tw-bg-white hover:tw-bg-slate-50">${r.city}</button>`).join('');
      cityList.addEventListener('click', function(ev){
        const b = ev.target.closest('button[data-city]'); if (!b) return;
        const c = b.getAttribute('data-city');
        inputCity.value = c; inputQ.value = c; search();
      });
    }catch(e){ /* silent */ }
  }

  function priceNum(x){ return Number(x || 0); }

  function applyClientFilters(items){
    let out = items.slice();
    const min = (minPrice && minPrice.value) ? Number(minPrice.value) : null;
    const max = (maxPrice && maxPrice.value) ? Number(maxPrice.value) : null;
    if (min !== null) out = out.filter(i => priceNum(i.from_price) >= min);
    if (max !== null) out = out.filter(i => priceNum(i.from_price) <= max);
    // Category & rating are stubs for now (no data fields guaranteed)
    return out;
  }

  function applySort(items){
    const s = selectSort.value;
    const arr = items.slice();
    if (s === 'price_asc') arr.sort((a,b)=>priceNum(a.from_price)-priceNum(b.from_price));
    else if (s === 'price_desc') arr.sort((a,b)=>priceNum(b.from_price)-priceNum(a.from_price));
    return arr;
  }

  function renderPager(total){
    const pages = Math.max(1, Math.ceil(total / pageSize));
    if (page > pages) page = pages;
    const btnBase = "tw-inline-flex tw-items-center tw-justify-center tw-rounded-lg tw-border tw-border-slate-300 tw-bg-white hover:tw-bg-slate-50 tw-text-slate-700 tw-px-2.5 tw-py-1 tw-text-sm";
    const btnActive = "tw-bg-blue-700 tw-text-white tw-border-blue-700 hover:tw-bg-blue-800";
    const btnDisabled = "tw-opacity-50 tw-pointer-events-none";
    const toLink = (p) => `<li><a class="page-link ${btnBase} ${p===page?btnActive:''}" href="#" data-page="${p}">${p}</a></li>`;
    const parts = [];
    parts.push(`<ul class="tw-flex tw-items-center tw-gap-1">`);
    parts.push(`<li><a class="page-link ${btnBase} ${page<=1?btnDisabled:''}" href="#" data-page="${page-1}">Prev</a></li>`);
    for (let p=1;p<=pages;p++){
      if (p===1||p===pages||Math.abs(p-page)<=2) { parts.push(toLink(p)); }
      else if (Math.abs(p-page)===3) { parts.push(`<li><span class="${btnBase} tw-cursor-default">…</span></li>`); }
    }
    parts.push(`<li><a class="page-link ${btnBase} ${page>=pages?btnDisabled:''}" href="#" data-page="${page+1}">Next</a></li>`);
    parts.push(`</ul>`);
    const html = parts.join('');
    pagerTop.innerHTML = html;
    pagerBottom.innerHTML = html;
    [pagerTop, pagerBottom].forEach(el => el.querySelectorAll('a.page-link').forEach(a => a.addEventListener('click', (ev)=>{
      ev.preventDefault();
      const p = Number(a.getAttribute('data-page'));
      if (!Number.isNaN(p) && p>=1) { page = p; draw(); window.scrollTo({top:0,behavior:'smooth'}); }
    })));
  }

  function cardHtml(a){
    const currency = a.currency || 'THB';
    const amount = priceNum(a.from_price).toFixed(2);
    const priceHtml = (currency === 'THB')
      ? `<span class=\"tw-font-semibold\" title=\"Thai Baht\">฿</span> ${amount}`
      : `${currency} ${amount}`;
    const tags = a.tags && a.tags.length ? a.tags.slice(0,3) : [];
    return `
      <article class="tw-rounded-2xl tw-bg-white tw-shadow-sm tw-ring-1 tw-ring-slate-100 tw-p-3 tw-transition hover:tw-shadow-md">
        <div class="tw-grid sm:tw-grid-cols-12 tw-gap-3">
          <div class="sm:tw-col-span-3">
            <div class="tw-w-full tw-h-24 tw-bg-slate-100 tw-rounded-xl tw-overflow-hidden">
              ${a.thumbnail ? `<img class=\"tw-w-full tw-h-full tw-object-cover\" src=\"${a.thumbnail}\" alt=\"${a.name}\" loading=\"lazy\"/>` : ''}
            </div>
          </div>
          <div class="sm:tw-col-span-6 tw-p-2">
            <h3 class="tw-font-semibold">${a.name}</h3>
            <div class="tw-mt-1 tw-text-sm tw-text-slate-600">${a.subtitle || 'Popular experience'}</div>
            ${a.city ? `
            <div class=\"tw-mt-1 tw-text-xs tw-text-slate-500 tw-flex tw-items-center tw-gap-1\">
              <svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" fill=\"currentColor\" class=\"tw-w-4 tw-h-4 tw-text-slate-400\"><path fill-rule=\"evenodd\" d=\"M11.54 22.35a.75.75 0 00.92 0c1.106-.866 6.79-5.476 6.79-11.1a7.25 7.25 0 10-14.5 0c0 5.624 5.684 10.234 6.79 11.1zM12 12.5a2.5 2.5 0 100-5 2.5 2.5 0 000 5z\" clip-rule=\"evenodd\"/></svg>
              <span>${a.city}</span>
            </div>` : ''}
            ${ (a.show_time || a.showtime || (a.times && a.times.length)) ? `
            <div class=\"tw-mt-1 tw-text-xs tw-text-slate-600\"><span class=\"tw-font-medium\">Show time:</span> ${a.show_time || a.showtime || (Array.isArray(a.times)? a.times.join(', '): '')}</div>` : ''}
          </div>
          <div class="sm:tw-col-span-3 tw-p-2 tw-flex tw-flex-col tw-justify-between tw-items-stretch sm:tw-items-end sm:tw-border-l tw-border-slate-100 sm:tw-pl-4 tw-gap-2">
            <div class="tw-text-left sm:tw-text-right">
              <div class="tw-text-slate-500 tw-text-xs">Starting from</div>
              <div class="tw-text-2xl tw-font-extrabold">${priceHtml}</div>
              <div class="tw-text-slate-500 tw-text-[11px]">per person</div>
            </div>
            <button type="button" class="tw-inline-flex tw-items-center tw-justify-center tw-gap-2 tw-rounded-full tw-bg-blue-900 hover:tw-bg-blue-800 tw-text-white tw-px-5 tw-py-2 tw-text-sm tw-shadow-sm tw-w-full sm:tw-w-auto" data-id="${a.id}">
              <span>Select Package</span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="tw-w-4 tw-h-4"><path stroke-linecap="round" stroke-linejoin="round" d="M8.25 4.5l7.5 7.5-7.5 7.5" /></svg>
            </button>
          </div>
        </div>
      </article>`;
  }

  function draw(){
    // Filter + sort + paginate
    let items = applyClientFilters(allItems);
    const total = items.length;
    items = applySort(items);
    const start = (page-1)*pageSize;
    const slice = items.slice(start, start+pageSize);
    meta.textContent = `${total} activit${total===1?'y':'ies'} found`;
    if (!slice.length) { list.innerHTML = '<div class="tw-text-slate-500 tw-text-sm">No activities found. Try different filters.</div>'; renderPager(total); return; }
    list.innerHTML = slice.map(cardHtml).join('');
    renderPager(total);
  }

  function updateFiltersSummary(){
    const parts = [];
    // Duration chips selected
    document.querySelectorAll('[data-duration].chip').forEach(btn => {
      const active = btn.classList.contains('tw-border-blue-600');
      if (active) parts.push(btn.textContent.trim());
    });
    // City
    if ((inputCity.value||'').trim()) parts.push((inputCity.value||'').trim());
    // Policies
    document.querySelectorAll('.filter-policy').forEach(cb => { if (cb.checked) parts.push(cb.parentElement.textContent.trim()); });
    // Price
    if (minPrice && minPrice.value) parts.push(`Min ${minPrice.value}`);
    if (maxPrice && maxPrice.value) parts.push(`Max ${maxPrice.value}`);

    filtersSummary.innerHTML = parts.length
      ? parts.map(t=>`<span class="tw-inline-flex tw-items-center tw-gap-1 tw-text-xs tw-bg-slate-100 tw-border tw-border-slate-200 tw-rounded-full tw-px-2 tw-py-0.5">${t}</span>`).join('')
      : '<span class="tw-text-xs tw-text-slate-500">No filters applied</span>';
  }

  const overlay = document.getElementById('loadingOverlay');
  function setLoading(on){ if (!overlay) return; overlay.classList.toggle('tw-hidden', !on); }

  async function search() {
    const q = (inputQ.value || '').trim();
    const city = (inputCity.value || '').trim();
    const params = new URLSearchParams();
    if (q) params.set('q', q);
    if (city) params.set('city', city);
    list.innerHTML = skeleton();
    meta.textContent = 'Searching…';
    page = 1;
    setLoading(true);
    try {
      const res = await fetch(`/b2b/api/activities/search?${params.toString()}`, { headers: { 'Accept': 'application/json' } });
      const json = await res.json();
      allItems = Array.isArray(json.data) ? json.data : [];
      draw();
      // Sync URL
      const newUrl = `/agent/activities${params.toString()?('?' + params.toString()):''}`;
      if (newUrl !== window.location.pathname + window.location.search) {
        window.history.replaceState(null, '', newUrl);
      }
    } catch (e) {
      meta.textContent = '';
      list.innerHTML = '<div class="tw-text-red-600 tw-text-sm">Failed to load activities.</div>';
    } finally { setLoading(false); }
  }

  form.addEventListener('submit', function(ev){ ev.preventDefault(); search(); });
  // sort control removed in this design
  btnApplyFilters.addEventListener('click', function(){ page=1; updateFiltersSummary(); draw(); if (filtersContent) filtersContent.classList.add('tw-hidden'); });
  btnClearFilters.addEventListener('click', function(ev){
    ev.preventDefault();
    // Reset chips
    document.querySelectorAll('[data-duration].chip').forEach(btn => {
      btn.classList.remove('tw-border-blue-600','tw-text-blue-700','tw-bg-blue-50');
    });
    // Reset policies (no type checkboxes anymore)
    document.querySelectorAll('.filter-policy').forEach(cb => { cb.checked = false; });
    // Reset city
    inputCity.value = '';
    // Also clear visible q if it only contained city
    if (inputQ && (!inputQ.value || inputQ.value === inputCity.value)) inputQ.value = '';
    // Reset price inputs if present
    if (minPrice) minPrice.value = '';
    if (maxPrice) maxPrice.value = '';
    updateFiltersSummary();
    page=1; draw();
  });
  // Toggle active style for duration chips (visual only for now)
  document.querySelectorAll('[data-duration].chip').forEach(btn => {
    btn.addEventListener('click', () => {
      btn.classList.toggle('tw-border-blue-600');
      btn.classList.toggle('tw-text-blue-700');
      btn.classList.toggle('tw-bg-blue-50');
    });
  });
  // Filters toggle (desktop summary bar button)
  if (filtersToggleBtn && filtersContent){
    const labelSpan = filtersToggleBtn.querySelector('span');
    // Desktop: always visible, label should say Hide
    if (labelSpan) { labelSpan.textContent = 'Hide'; }
    filtersToggleBtn.addEventListener('click', ()=>{
      const mql = window.matchMedia('(min-width: 768px)');
      if (mql.matches) {
        // On desktop, keep it visible and no-op the toggle (prevent accidental hide)
        if (labelSpan) { labelSpan.textContent = 'Hide'; }
        return;
      }
      const willShow = filtersContent.classList.contains('tw-hidden');
      filtersContent.classList.toggle('tw-hidden');
      if (labelSpan){ labelSpan.textContent = willShow ? 'Hide' : 'Show'; }
    });
  }
  // Mobile filters toggle uses the same content area
  (function(){
    const btn = mobileFiltersBtn;
    const panel = filtersContent;
    if (!btn || !panel) return;
    const mql = window.matchMedia('(min-width: 768px)');
    // Ensure correct state on load and when resizing
    const ensureState = () => {
      if (mql.matches) {
        panel.classList.remove('tw-hidden');
      }
    };
    ensureState();
    mql.addEventListener('change', ensureState);
    // Mobile toggle only
    btn.addEventListener('click', ()=>{ if (!mql.matches) panel.classList.toggle('tw-hidden'); });
  })();
  // View toggle removed; default remains list

  // Auto-run search on first load; also load cities list
  loadCities();
  search();
  updateFiltersSummary();

  // Navigate to detail on View
  list.addEventListener('click', function(ev){
    const btn = ev.target.closest('button[data-id]');
    if (!btn) return;
    const id = btn.getAttribute('data-id');
    if (id) window.location.href = '/agent/activities/detail?id=' + encodeURIComponent(id);
  });
})();
</script>

<style>
  /* Full-page whitesmoke wrapper to ensure consistent background regardless of theme layers */
  .activities-page-bg { background: #f5f5f5 !important; min-height: 100vh; width: 100%; }

  /* Booking.com-like light gray page background - enforce on html and body */
  html.bg-booking, body.bg-booking { background-color: #f5f5f5 !important; }

  /* HARD override of global gradient in main layout for this page only */
  body.b2b.page-activities { background: #f5f5f5 !important; background-image: none !important; }

  /* Removed Bootstrap-based results list/card CSS; cards now use Tailwind utilities in markup */
  .chip.tw-border-blue-600.tw-text-blue-700.tw-bg-blue-50 { box-shadow: inset 0 0 0 1px rgba(29, 78, 216, 0.2); }
</style>
