<?php
// app/Views/agent/bookings.php
?>
<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h1 class="h5 mb-0">My Bookings</h1>
    <div class="d-flex gap-2">
      <a href="/agent/orders" class="btn btn-sm btn-outline-primary"><i class="bi bi-receipt me-1"></i> Orders</a>
      <a href="/agent/wallet" class="btn btn-sm btn-outline-secondary"><i class="bi bi-wallet2 me-1"></i> Wallet</a>
    </div>
  </div>

  <div class="card shadow-sm mb-4">
    <div class="card-header bg-white d-flex align-items-center justify-content-between">
      <div>
        <strong>Pending Bookings</strong>
        <span class="badge bg-warning text-dark ms-2">Payment Due</span>
      </div>
      <div class="small text-muted">Count: <?php echo isset($pending) ? count($pending) : 0; ?></div>
    </div>
    <div class="table-responsive">
      <table class="table align-middle mb-0">
        <thead>
          <tr>
            <th>ID</th>
            <th>Item</th>
            <th>PAX</th>
            <th>Price</th>
            <th>Status</th>
            <th>Created</th>
            <th class="text-end">Action</th>
          </tr>
        </thead>
        <tbody>
        <?php if (!empty($pending)): foreach ($pending as $b): ?>
          <tr>
            <td>#<?php echo (int)$b['id']; ?></td>
            <td>
              <div class="text-capitalize fw-semibold"><?php echo htmlspecialchars($b['module']); ?></div>
              <div class="text-muted small text-truncate" style="max-width:320px;">
                <?php echo htmlspecialchars($b['item_name'] ?? ''); ?>
              </div>
            </td>
            <td><?php echo (int)$b['pax']; ?></td>
            <td><strong><?php echo number_format((float)$b['price'], 2); ?></strong> THB</td>
            <td><span class="badge bg-warning text-dark">Pending</span></td>
            <td class="text-nowrap">&nbsp;<?php echo htmlspecialchars($b['created_at'] ?? ''); ?></td>
            <td class="text-end">
              <div class="btn-group btn-group-sm">
                <a href="/agent/booking/view?id=<?php echo (int)$b['id']; ?>" class="btn btn-outline-secondary"><i class="bi bi-eye"></i> View</a>
                <a href="/agent/booking/pay?id=<?php echo (int)$b['id']; ?>" class="btn btn-primary"><i class="bi bi-credit-card"></i> Pay via Wallet</a>
                <a href="/agent/support" class="btn btn-outline-secondary"><i class="bi bi-life-preserver"></i> Help</a>
              </div>
            </td>
          </tr>
        <?php endforeach; else: ?>
          <tr>
            <td colspan="7" class="text-center text-muted py-4">
              No pending bookings. Great! <a href="/agent/orders" class="ms-1">View your orders</a>.
            </td>
          </tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <div class="card shadow-sm">
    <div class="card-header bg-white d-flex align-items-center justify-content-between">
      <div>
        <strong>Paid Bookings</strong>
        <span class="text-muted small">(Orders)</span>
      </div>
      <div class="small text-muted">Count: <?php echo isset($paid) ? count($paid) : 0; ?></div>
    </div>
    <div class="table-responsive">
      <table class="table align-middle mb-0">
        <thead>
          <tr>
            <th>ID</th>
            <th>Item</th>
            <th>PAX</th>
            <th>Price</th>
            <th>Status</th>
            <th>Created</th>
            <th class="text-end">Action</th>
          </tr>
        </thead>
        <tbody>
        <?php if (!empty($paid)): foreach ($paid as $b): ?>
          <tr>
            <td>#<?php echo (int)$b['id']; ?></td>
            <td>
              <div class="text-capitalize fw-semibold"><?php echo htmlspecialchars($b['module']); ?></div>
              <div class="text-muted small text-truncate" style="max-width:320px;">
                <?php echo htmlspecialchars($b['item_name'] ?? ''); ?>
              </div>
            </td>
            <td><?php echo (int)$b['pax']; ?></td>
            <td><strong><?php echo number_format((float)$b['price'], 2); ?></strong> THB</td>
            <td>
              <?php $bs=(string)$b['status']; $badge=$bs==='confirmed'?'bg-success':($bs==='completed'?'bg-primary':'bg-secondary'); ?>
              <span class="badge <?php echo $badge; ?>"><?php echo htmlspecialchars($bs); ?></span>
            </td>
            <td class="text-nowrap">&nbsp;<?php echo htmlspecialchars($b['created_at'] ?? ''); ?></td>
            <td class="text-end">
              <a href="/agent/orders/view?id=<?php echo (int)$b['id']; ?>" class="btn btn-sm btn-outline-primary"><i class="bi bi-box-arrow-up-right"></i> View</a>
            </td>
          </tr>
        <?php endforeach; else: ?>
          <tr>
            <td colspan="7" class="text-center text-muted py-4">
              No paid bookings yet. Once you complete payment, they will appear here as orders.
            </td>
          </tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
