<?php
// Usage: php apply_wallet_deposit_patches.php
// Applies wallet deposit workflow patches safely and idempotently.

$cfg = require __DIR__ . '/config/config.php';
$pdo = $cfg['pdo'];

$patches = [
    __DIR__ . '/database/patches/2025-09-13_company_bank_accounts.sql',
    __DIR__ . '/database/patches/2025-09-13_wallet_deposit_requests.sql',
];

echo "Applying wallet deposit patches...\n";
foreach ($patches as $file) {
    if (!file_exists($file)) { echo "Missing: $file\n"; continue; }
    echo "\n-- Executing: " . basename($file) . "\n";
    $sql = file_get_contents($file);
    // naive split; assumes statements use semicolons at end and not inside procedures
    $stmts = array_filter(array_map('trim', explode(';', $sql)));
    $ok = 0; $fail = 0;
    foreach ($stmts as $stmt) {
        if ($stmt === '' || str_starts_with($stmt, '--')) continue;
        try {
            $pdo->exec($stmt);
            $ok++;
        } catch (Throwable $e) {
            $fail++;
            echo "  ✗ Error: " . $e->getMessage() . "\n";
        }
    }
    echo "  ✓ Done: $ok executed, $fail failed\n";
}

echo "\nAll done.\n";
